<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\Order;
use Carbon\Carbon;

class AutoCancelOrder extends Command
{
    protected $signature = 'order:auto-cancel';
    protected $description = 'Batalkan order pending lebih dari 3 hari';

    public function handle()
    {
        Order::where('status', 'pending')
            ->where('created_at', '<=', Carbon::now()->subDays(3))
            ->update([
                'status' => 'cancelled'
            ]);

        $this->info('Order pending > 3 hari berhasil dibatalkan');
    }
}

