<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use App\Models\Product;

class AdminDashboardController extends Controller
{
    public function index()
    {
        // 🔥 Total semua pesanan (semua status)
        $totalOrders = Order::count();

        // 🔥 Total pendapatan HANYA dari pesanan dibayar
        $totalRevenue = Order::whereIn('status', [
            'paid',
            'process',
            'shipped',
            'completed'
        ])->sum('total_price');

        // 🔥 Total produk aktif
        $totalProducts = Product::count();

        // 🔥 Tabel 5 pesanan terbaru
        $orders = Order::latest()->take(5)->get();

        // 🔥 Grafik bulanan (HANYA order dibayar)
        $monthlyData = Order::selectRaw('MONTH(created_at) as month, COUNT(*) as count')
            ->whereYear('created_at', date('Y'))
            ->whereIn('status', ['paid','process','shipped','completed'])
            ->groupBy('month')
            ->pluck('count', 'month')
            ->toArray();

        $chartData = [];
        for ($i = 1; $i <= 12; $i++) {
            $chartData[] = $monthlyData[$i] ?? 0;
        }

        return view('admin.dashboard', compact(
            'orders',
            'totalOrders',
            'totalRevenue',
            'totalProducts',
            'chartData'
        ));
    }
}
