<?php

namespace App\Http\Controllers;

use App\Models\Order;
use App\Models\OrderItem;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class CheckoutController extends Controller
{
    public function store(Request $request)
    {
        // CART (contoh dari session)
        $cart = session('cart', []);

        if (empty($cart)) {
            return back()->with('error', 'Keranjang kosong');
        }

        DB::transaction(function () use ($cart) {

            $order = Order::create([
                'user_id' => auth()->id(),
                'total_price' => collect($cart)->sum(
                    fn ($i) => $i['price'] * $i['qty']
                ),
                'status' => 'pending',
            ]);

            foreach ($cart as $item) {
                OrderItem::create([
                    'order_id' => $order->id,
                    'product_id' => $item['product_id'],
                    'qty' => $item['qty'],
                    'price' => $item['price'],
                ]);
            }
        });

        // Hapus cart setelah checkout
        session()->forget('cart');

        return redirect()
            ->route('orders.success')
            ->with('success', 'Pesanan berhasil dibuat');
    }
}
