<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;

class FinanceController extends Controller
{
    public function index()
    {
        $totalRevenue = Order::where('status', 'paid')->sum('total_price');
        $totalOrders = Order::where('status', 'paid')->count();

        $monthlyRevenue = Order::selectRaw('MONTH(created_at) as month, SUM(total_price) as total')
            ->where('status', 'paid')
            ->groupBy('month')
            ->get();

        return view('admin.finance.index', compact(
            'totalRevenue',
            'totalOrders',
            'monthlyRevenue'
        ));
    }
}
