<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Order;
use Illuminate\Http\Request;
use App\Models\Product;
use Illuminate\Support\Facades\DB;

class OrderController extends Controller
{
    public function index(Request $request)
{
    $query = Order::with(['user', 'items.product'])->latest();

    if ($request->filled('status')) {
        $query->where('status', $request->status);
    }

    $orders = $query->paginate(10)->withQueryString();

    return view('admin.orders.index', compact('orders'));
}



    public function show(Order $order)
    {
        return view('admin.orders.show', compact('order'));
    }

    // 🔥 UPDATE STATUS

 public function updateStatus(Request $request, Order $order)
{
    $request->validate([
        'status' => 'required|in:pending,paid,process,shipped,completed,cancelled',
        'courier' => 'required_if:status,shipped',
        'tracking_number' => 'required_if:status,shipped',
    ]);

    $old = $order->status;
    $new = $request->status;

    DB::transaction(function () use ($order, $old, $new, $request) {

        if ($old !== 'paid' && $new === 'paid') {
            foreach ($order->items as $item) {
                $item->product->decrement('stock', $item->qty);
            }
        }

        if ($new === 'shipped') {
            $order->update([
                'courier' => $request->courier,
                'tracking_number' => $request->tracking_number,
                'shipped_at' => now(),
            ]);
        }

        if ($new === 'completed') {
            $order->update(['completed_at' => now()]);
        }

        if ($new === 'cancelled' && in_array($old, ['paid','process','shipped'])) {
            foreach ($order->items as $item) {
                $item->product->increment('stock', $item->qty);
            }
        }

        $order->update(['status' => $new]);
    });

    return back()->with('success', 'Status diperbarui');
}



}