<?php

namespace App\Http\Controllers;

use App\Models\Order;
use Illuminate\Support\Facades\Auth;

class AkunController extends Controller
{
    public function index()
    {
        $orders = Order::with('items.product')
            ->where('user_id', Auth::id())
            ->latest()
            ->get();

        return view('akun', compact('orders'));
    }

    // ✅ CUSTOMER KONFIRMASI PESANAN SELESAI
    public function markAsCompleted(Order $order)
    {
        // 🔐 pastikan hanya pemilik pesanan
        if ($order->user_id !== Auth::id()) {
            abort(403);
        }

        // hanya boleh jika sudah dikirim
        if ($order->status !== 'shipped') {
            return back()->with('error', 'Pesanan belum bisa diselesaikan');
        }

        $order->update([
            'status' => 'completed',
            'completed_at' => now(),
        ]);

        return back()->with('success', 'Pesanan berhasil diselesaikan');
    }
}
