<?php

namespace App\Http\Controllers;

use App\Models\Product;
use Illuminate\Http\Request;

class CartController extends Controller
{
    // ======================
    // HALAMAN KERANJANG
    // ======================
    public function index()
    {
        $cart = session('cart', []);
        $total = collect($cart)->sum(fn ($i) => $i['price'] * $i['qty']);

        return view('cart.index', compact('cart', 'total'));
    }

    // ======================
    // TAMBAH KE KERANJANG
    // ======================
    public function add(Request $request, $productId)
    {
        $product = Product::findOrFail($productId);
        $cart = session()->get('cart', []);

        if (isset($cart[$productId])) {
            $cart[$productId]['qty']++;
        } else {
            $cart[$productId] = [
                'name'  => $product->name,
                'price' => $product->price,
                'qty'   => 1,
                'image' => $product->image,
            ];
        }

        session()->put('cart', $cart);

        // 👉 ORDER NOW → langsung checkout
        if ($request->input('redirect') === 'checkout') {
            return redirect()->route('checkout.index');
        }

        // 👉 default: ke cart
        return redirect()->route('cart.index');
    }

    // ======================
    // UPDATE QTY
    // ======================
    public function update(Request $request, $productId)
    {
        $cart = session()->get('cart', []);
        $qty = max(1, (int) $request->qty);

        if (!isset($cart[$productId])) {
            return response()->json(['error' => 'Item tidak ditemukan'], 404);
        }

        $cart[$productId]['qty'] = $qty;
        session()->put('cart', $cart);

        $subtotal = $cart[$productId]['price'] * $qty;
        $total = collect($cart)->sum(fn ($i) => $i['price'] * $i['qty']);

        return response()->json([
            'subtotal' => 'Rp ' . number_format($subtotal),
            'total'    => 'Rp ' . number_format($total),
        ]);
    }

    // ======================
    // HAPUS ITEM
    // ======================
    public function remove($productId)
    {
        $cart = session()->get('cart', []);
        unset($cart[$productId]);
        session()->put('cart', $cart);

        $total = collect($cart)->sum(fn ($i) => $i['price'] * $i['qty']);

        return response()->json([
            'total' => 'Rp ' . number_format($total),
            'empty' => count($cart) === 0
        ]);
    } // ✅ PENTING: DITUTUP DI SINI

    // ======================
    // CHECKOUT DARI CART
    // ======================
    public function checkout()
    {
        $cart = session('cart', []);

        if (empty($cart)) {
            return redirect()->route('cart.index')
                ->with('error', 'Keranjang kosong');
        }

        // 🔥 PINDAHKAN CART → CHECKOUT
        session([
            'checkout_cart' => $cart
        ]);

        return redirect()->route('checkout.index');
    }
}
