<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Order;
use Midtrans\Notification;

class MidtransController extends Controller
{
    public function callback(Request $request)
    {
        // Ambil notifikasi dari Midtrans
        $notification = new Notification();

        $orderId = $notification->order_id;
        $transactionStatus = $notification->transaction_status;
        $paymentType = $notification->payment_type;
        $fraudStatus = $notification->fraud_status ?? null;

        // Cari order di database kamu
        $order = Order::where('order_id', $orderId)->first();

        if (!$order) {
            return response()->json(['message' => 'Order tidak ditemukan'], 404);
        }

        /**
         * STATUS TRANSAKSI MIDTRANS
         * settlement = pembayaran sukses
         * pending    = belum dibayar
         * expire     = kadaluarsa
         * cancel     = dibatalkan
         * deny       = ditolak
         */
        if ($transactionStatus === 'settlement') {
            $order->status = 'paid';
            $order->method = $paymentType; // qris
        } elseif ($transactionStatus === 'pending') {
            $order->status = 'pending';
        } else {
            $order->status = 'cancelled';
        }

        $order->save();

        // WAJIB kirim response 200 ke Midtrans
        return response()->json(['message' => 'Callback berhasil']);
    }
}
