<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class AdminMiddleware
{
    public function handle(Request $request, Closure $next): Response
{
    if (!auth()->check()) {
        return redirect()->route('login');
    }

    if (auth()->user()->role !== 'admin') {
        return redirect()->route('akun')
            ->with('error', 'Anda tidak memiliki akses admin');
    }

    return $next($request);
}

}
