<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Order extends Model
{
    protected $fillable = [
        'user_id',
        'receiver_name',
        'address',
        'phone',
        'payment_channel',
        'payment_name',
        'payment_number',
        'method',
        'shipping_cost',
        'total_price',
        'status',
        'payment_proof',

        // ✅ TAMBAHKAN INI
        'courier',
        'tracking_number',
        'shipped_at',
        'completed_at',
    ];

    // RELASI
    public function items()
    {
        return $this->hasMany(OrderItem::class);
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
