<?php

namespace App\Services;

use Illuminate\Support\Facades\Http;

class BiteshipService
{
    protected string $key;

    public function __construct()
    {
        $this->key = config('services.biteship.key');
    }

    protected function headers(): array
    {
        return [
            'Authorization' => $this->key,
            'Content-Type'  => 'application/json',
        ];
    }

    // =============================
    // SEARCH AREA
    // =============================
    public function cities(string $query)
    {
        return Http::withHeaders($this->headers())
            ->get('https://api.biteship.com/v1/maps/areas', [
                'countries' => 'ID',
                'input'     => $query,
                'type'      => 'single',
            ])
            ->json();
    }

    // =============================
    // HITUNG ONGKIR
    // =============================
    public function rates(string $destinationAreaId, int $weight, string $courier, int $qty = 1)
    {
        // =============================
        // LOGIKA BERAT BERDASARKAN JUMLAH
        // =============================
        $weightPerItem = 250; // gram
        $totalWeight   = max($weight, $qty * $weightPerItem);

        // =============================
        // HITUNG ONGKIR TAMBAHAN
        // =============================
        $extra = $qty > 4
            ? ceil(($qty - 4) / 2) * 5000
            : 0;

        // =============================
        // CALL API BITESHIP
        // =============================
        $res = Http::withHeaders($this->headers())
            ->post('https://api.biteship.com/v1/rates/couriers', [
                'origin_area_id'      => 'IDNP11IDNC158IDND1022IDZ61462',
                'destination_area_id' => $destinationAreaId,
                'couriers'            => $courier,
                'items' => [
                    [
                        'name'     => 'Pesanan Kopi',
                        'weight'   => $totalWeight,
                        'quantity' => $qty,
                        'value'    => 30000 * $qty,
                    ]
                ]
            ])
            ->json();

        // =============================
        // JIKA API SUKSES → TAMBAHKAN EXTRA
        // =============================
        if (($res['success'] ?? false) === true && isset($res['pricing'])) {
            if ($extra > 0) {
                foreach ($res['pricing'] as &$service) {
                    $service['price'] += $extra;
                }
                unset($service);
            }
            return $res;
        }

        // =============================
        // SIMULASI JIKA API GAGAL
        // =============================
        $simulasi = [
            'jne' => [
                [
                    'courier_name' => 'JNE',
                    'service_name' => 'REG',
                    'duration'     => '2-3 Hari',
                    'price'        => 12000 + $extra,
                ],
                [
                    'courier_name' => 'JNE',
                    'service_name' => 'YES',
                    'duration'     => '1 Hari',
                    'price'        => 20000 + $extra,
                ],
            ],
            'jnt' => [
                [
                    'courier_name' => 'J&T',
                    'service_name' => 'EZ',
                    'duration'     => '2-3 Hari',
                    'price'        => 11000 + $extra,
                ],
                [
                    'courier_name' => 'J&T',
                    'service_name' => 'EXPRESS',
                    'duration'     => '1-2 Hari',
                    'price'        => 17000 + $extra,
                ],
            ],
            'sicepat' => [
                [
                    'courier_name' => 'SiCepat',
                    'service_name' => 'REG',
                    'duration'     => '2-3 Hari',
                    'price'        => 10000 + $extra,
                ],
                [
                    'courier_name' => 'SiCepat',
                    'service_name' => 'BEST',
                    'duration'     => '1 Hari',
                    'price'        => 16000 + $extra,
                ],
            ],
        ];

        return [
            'success' => true,
            'pricing' => $simulasi[$courier] ?? [],
        ];
    }
}
