<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
{
    Schema::table('orders', function (Blueprint $table) {

        // kalau BELUM ADA shipping_cost
        if (!Schema::hasColumn('orders', 'shipping_cost')) {
            $table->integer('shipping_cost')->after('method');
        }

        // kalau BELUM ADA snap_token
        if (!Schema::hasColumn('orders', 'snap_token')) {
            $table->string('snap_token')->nullable()->after('tracking_number');
        }
    });
}

    public function down(): void
{
    Schema::table('orders', function (Blueprint $table) {
        if (Schema::hasColumn('orders', 'shipping_cost')) {
            $table->dropColumn('shipping_cost');
        }

        if (Schema::hasColumn('orders', 'snap_token')) {
            $table->dropColumn('snap_token');
        }
    });
}

};
