<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // User biasa (opsional)
        User::factory()->create([
            'name' => 'Test User',
            'username' => 'testuser',
            'email' => 'test@example.com',
            'role' => 'user',
        ]);

        // 🔥 ADMIN UTAMA
        User::firstOrCreate(
            ['email' => 'kopiketjeh@gmail.com'],
            [
                'name' => 'Admin',
                'username' => 'admin',
                'password' => Hash::make('Kopiketjeh.id08'),
                'role' => 'admin',
            ]
        );
    }
}
