@extends('layouts.admin')

@section('title', 'Dashboard Admin')

@push('extra-css')
    <link rel="stylesheet" href="{{ asset('assets/css/admin-custom.css') }}">
    <style>
        /* Memastikan angka perhitungan berwarna cokelat sesuai permintaan */
        .stat-card .stat-info h2 {
            color: #4e342e !important;
            font-weight: 800;
        }
        /* Pengecualian untuk kartu featured agar tetap putih */
        .stat-card.featured .stat-info h2 {
            color: #ffffff !important;
        }
        /* Style tambahan untuk panel grafik */
        .chart-panel {
            background: #ffffff;
            border-radius: 15px;
            padding: 20px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.05);
            margin-bottom: 25px;
            border: 1px solid #efebe9;
        }
    </style>
@endpush

@section('content')
<div class="dashboard-container">
    
    {{-- 1. HEADER DASHBOARD --}}
    <div class="dash-header">
        <div class="header-text">
            <h1 class="dash-title">Dashboard Admin</h1>
            <p class="dash-sub">Ringkasan aktivitas operasional <strong>Kopi Ketjeh</strong> hari ini.</p>
        </div>
        <div class="header-action">
            <button class="btn-refresh" onclick="location.reload()">
                <i class="fas fa-sync-alt"></i> Refresh Data
            </button>
        </div>
    </div>

    {{-- 2. GRAFIK PENJUALAN (POSISI ATAS) --}}
    <div class="chart-panel">
        <div class="panel-header" style="border: none; padding-bottom: 15px; display: flex; align-items: center; gap: 10px;">
            <h3 style="color: #4e342e; margin: 0;"><i class="fas fa-chart-line"></i> Tren Pesanan Bulanan {{ date('Y') }}</h3>
        </div>
        <div style="height: 280px;">
            <canvas id="orderChart"></canvas>
        </div>
    </div>

    {{-- 3. STATS CARDS (POSISI TENGAH) --}}
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon-wrapper color-1">
                <i class="fas fa-shopping-basket"></i>
            </div>
            <div class="stat-info">
                <span>Total Pesanan</span>
                <h2>{{ number_format($totalOrders) }}</h2>
            </div>
        </div>

        <div class="stat-card featured" style="background-color: #4e342e !important;">
            <div class="stat-icon-wrapper color-2">
                <i class="fas fa-wallet"></i>
            </div>
            <div class="stat-info">
                <span>Total Pendapatan</span>
                <h2>Rp {{ number_format($totalRevenue, 0, ',', '.') }}</h2>
            </div>
        </div>

        <div class="stat-card">
            <div class="stat-icon-wrapper color-3">
                <i class="fas fa-coffee"></i>
            </div>
            <div class="stat-info">
                <span>Produk Aktif</span>
                <h2>{{ $totalProducts }}</h2>
            </div>
        </div>
    </div>

    {{-- 4. TABEL PESANAN (POSISI BAWAH) --}}
    <div class="content-panel">
        <div class="panel-header">
        <h3>Riwayat Transaksi</h3>
        <a href="{{ route('admin.orders.index') }}" class="link-more" style="color: #4e342e; font-weight: 600; text-decoration: none;">
            Lihat Semua <i class="fas fa-arrow-right" style="font-size: 0.8rem;"></i>
        </a>
    </div>
    <div class="table-responsive">    
        <div class="table-container">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th width="10%">ID</th>
                        <th width="25%">WAKTU</th>
                        <th width="35%">TOTAL HARGA</th>
                        <th width="30%">METODE TRANSAKSI</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($orders as $order)
                        @php
                            // Logika pendeteksi metode transaksi secara otomatis
                            $rawMethod = strtolower($order->method ?? 'website');
                            if(str_contains($rawMethod, 'wa') || str_contains($rawMethod, 'whatsapp')) {
                                $badge = ['class' => 'bg-whatsapp', 'icon' => 'fab fa-whatsapp', 'label' => 'WhatsApp'];
                            } elseif(str_contains($rawMethod, 'shopee')) {
                                $badge = ['class' => 'bg-shopee', 'icon' => 'fas fa-shopping-bag', 'label' => 'Shopee'];
                            } else {
                                // Default warna cokelat kopi untuk Website
                                $badge = ['class' => 'bg-website', 'icon' => 'fas fa-globe', 'label' => 'Website'];
                            }
                        @endphp
                        <tr>
                            <td class="order-id">#{{ $order->id }}</td>
                            <td class="order-date">
                                <span style="display: block; font-weight: 600;">{{ $order->created_at->format('d M Y') }}</span>
                                <small class="text-muted" style="font-size: 0.75rem;">
                                    <i class="far fa-clock"></i> {{ $order->created_at->format('H:i') }} WIB
                                </small>
                            </td>
                            <td class="order-price">
                                Rp {{ number_format($order->total_price, 0, ',', '.') }}
                            </td>
                            <td>
                                <span class="badge-transaksi {{ $badge['class'] }}">
                                    <i class="{{ $badge['icon'] }}"></i> {{ $badge['label'] }}
                                </span>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="4" style="text-align: center; padding: 80px; color: #999;">
                                <i class="fas fa-inbox fa-3x" style="opacity: 0.2; margin-bottom: 15px;"></i><br>
                                Belum ada transaksi masuk hari ini.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>    
    </div>
</div>
@endsection

@push('extra-js')
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    const ctx = document.getElementById('orderChart').getContext('2d');
    new Chart(ctx, {
        type: 'line',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'Mei', 'Jun', 'Jul', 'Agu', 'Sep', 'Okt', 'Nov', 'Des'],
            datasets: [{
                label: 'Jumlah Pesanan',
                data: @json($chartData),
                borderColor: '#4e342e',
                backgroundColor: 'rgba(78, 52, 46, 0.1)',
                borderWidth: 3,
                tension: 0.4,
                fill: true,
                pointBackgroundColor: '#4e342e',
                pointRadius: 5,
                pointHoverRadius: 7
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            // Perbaikan resolusi agar grafik tidak pecah saat zoom
            devicePixelRatio: 2, 
            plugins: {
                legend: { display: false }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    suggestedMax: 5, // Skala minimal 5 agar proporsional
                    ticks: { 
                        stepSize: 1,
                        color: '#4e342e',
                        font: { weight: 'bold' }
                    },
                    grid: { color: 'rgba(0,0,0,0.05)' }
                },
                x: {
                    ticks: { 
                        color: '#4e342e',
                        font: { weight: 'bold' }
                    },
                    grid: { display: false }
                }
            }
        }
    });
</script>
@endpush