@extends('layouts.admin')

@section('title', 'Kelola Pesanan')

@section('content')
<div class="dashboard-container">
    
    {{-- HEADER HALAMAN --}}
    <div class="dash-header">
        <div class="header-text">
            <h1 class="dash-title">Kelola Pesanan</h1>
            <p class="dash-sub">
                Pantau arus transaksi dan perbarui status pengiriman pelanggan secara real-time.
            </p>
        </div>
        <button onclick="window.location.reload()" class="btn-refresh">
            <i class="fas fa-sync-alt"></i> Refresh Data
        </button>
    </div>

    {{-- FLASH MESSAGE --}}
    @if(session('success'))
        <div class="alert alert-success"
             style="background:#dcfce7;color:#166534;border-left:5px solid #22c55e;
                    padding:12px;border-radius:8px;margin-bottom:20px;">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    {{-- FILTER STATUS --}}
    <div class="filter-group">
        <a href="{{ route('admin.orders.index') }}"
           class="btn-filter {{ request('status') === null ? 'active' : '' }}">
            Semua
        </a>
        @foreach(['pending','paid','process','shipped','completed','cancelled'] as $status)
            <a href="{{ route('admin.orders.index', ['status' => $status]) }}"
               class="btn-filter {{ request('status') === $status ? 'active' : '' }}">
                {{ ucfirst($status) }}
            </a>
        @endforeach
    </div>

    {{-- KONTEN PANEL --}}
    <div class="content-panel">
        <div class="table-responsive">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th style="width:5%; text-align:center;">No</th>
                        <th style="width:16%;">Tanggal</th>
                        <th style="width:15%;">Pelanggan</th>
                        <th style="width:22%;">Detail Pesanan</th>
                        <th style="width:14%;">Kurir</th>
                        <th style="width:12%;" class="text-end">Total</th>
                        <th style="width:14%; text-align:center;">Status</th>
                        <th style="width:10%; text-align:center;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($orders as $order)
                        <tr>
                            {{-- ID --}}
                            <td style="text-align:center;font-weight:700;color:#6d4c41;">
                                #{{ $order->id }}
                            </td>

                            {{-- TANGGAL --}}
                            <td>
                                <div style="font-weight:600;">
                                    {{ $order->created_at->format('d M Y') }}
                                </div>
                                <small style="color:#8d6e63;">
                                    <i class="far fa-clock"></i>
                                    {{ $order->created_at->format('H:i') }} WIB
                                </small>
                            </td>
                            <td>
                                <strong>{{ $order->user->name ?? '-' }}</strong><br>
                                <small style="color:#6b7280;">
                                {{ $order->user->email ?? '-' }}
                                </small>
                            </td>

                            <td>
                                @foreach($order->items as $item)
                                    <div style="font-size:13px;">
                                        {{ $item->product->name }}
                                        <small style="color:#6b7280;">x{{ $item->qty }}</small>
                                    </div>
                                @endforeach
                            </td>

                            {{-- 🔥 TAMBAHAN: KURIR --}}
                            <td>
                                @if($order->courier)
                                    <strong style="text-transform:uppercase;">
                                        {{ $order->courier }}
                                    </strong>
                                    <br>
                                    <small style="color:#6b7280;">
                                        {{ $order->courier_service }}
                                    </small>
                                @else
                                    <span style="color:#9ca3af;">-</span>
                                @endif
                            </td>

                            {{-- TOTAL --}}
                            <td class="order-price-bold">
                                Rp {{ number_format($order->total_price, 0, ',', '.') }}
                            </td>

                            {{-- STATUS --}}
                            <td>
                                <form method="POST"
                                      action="{{ route('admin.orders.updateStatus', $order) }}">
                                    @csrf
                                    @method('PATCH')
                                    <select name="status"
                                            class="status-select"
                                            onchange="this.form.submit()">
                                        @foreach(['pending','paid','process','shipped','completed','cancelled'] as $st)
                                            <option value="{{ $st }}"
                                                {{ $order->status === $st ? 'selected' : '' }}>
                                                {{ ucfirst($st) }}
                                            </option>
                                        @endforeach
                                    </select>
                                </form>
                            </td>

                            {{-- AKSI --}}
                            <td style="text-align:center;">
                                <a href="{{ route('admin.orders.show', $order) }}"
                                   class="link-edit">
                                    <i class="fas fa-eye"></i> DETAIL
                                </a>
                            </td>
                        </tr>
                    @empty
                        <tr>
                            <td colspan="7"
                                style="text-align:center;padding:40px;color:#8d6e63;">
                                <i class="fas fa-box-open"
                                   style="font-size:2rem;display:block;margin-bottom:10px;"></i>
                                Tidak ada data pesanan ditemukan.
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    {{-- PAGINATION --}}
    <div style="margin-top:25px;">
        {{ $orders->links() }}
    </div>
</div>
@endsection
