@extends('layouts.admin')

@section('title', 'Detail Pesanan #' . $order->id)

@section('content')
<div class="kopi-order-card">

    {{-- ================= HEADER ================= --}}
    <div class="kopi-card-header">
        <div class="header-info">
            <h3>
                <i class="fas fa-receipt"></i>
                Detail Pesanan #{{ $order->id }}
            </h3>
            <p>Informasi transaksi dan pengiriman Kopi Ketjeh</p>
        </div>

        <a href="{{ route('admin.orders.index') }}" class="btn-kopi-back">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    {{-- ================= FLASH MESSAGE ================= --}}
    @if(session('success'))
        <div class="kopi-alert-success">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    <div class="kopi-card-body">

        {{-- ================= DATA PELANGGAN ================= --}}
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-user-circle"></i> Data Pelanggan
            </h4>

            <div class="kopi-detail-list">
                <div class="detail-item">
                    <strong>Nama Akun:</strong>
                    <span>{{ $order->user->name ?? '-' }}</span>
                </div>

                <div class="detail-item">
                    <strong>Nama Penerima:</strong>
                    <span>{{ $order->receiver_name ?? '-' }}</span>
                </div>

                <div class="detail-item">
                    <strong>Alamat Pengiriman:</strong>
                    <span>{{ $order->address }}</span>
                </div>

                <div class="detail-item">
                    <strong>No. WhatsApp:</strong>
                    <span>{{ $order->phone }}</span>
                </div>
            </div>
        </div>

        {{-- ================= DATA PEMBAYARAN ================= --}}
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-credit-card"></i> Data Pembayaran
            </h4>

            <div class="kopi-detail-list">
                <div class="detail-item">
                    <strong>Metode:</strong>
                    <span>{{ strtoupper($order->payment_method ?? '-') }}</span>
                </div>

                <div class="detail-item">
                    <strong>Bank / E-Wallet:</strong>
                    <span>{{ strtoupper($order->payment_name ?? '-') }}</span>
                </div>

                <div class="detail-item">
                    <strong>Nomor Tujuan:</strong>
                    <span>{{ $order->payment_number ?? '-' }}</span>
                </div>

                <div class="detail-item">
                    <strong>Atas Nama:</strong>
                    <span>Kopi Ketjeh</span>
                </div>

                <div class="detail-item">
                    <strong>Status Pembayaran:</strong>
                    @if($order->status === 'pending')
                        <span style="color:#b45309;font-weight:700;"><i class="fas fa-clock"></i>
                            Menunggu Pembayaran
                        </span>
                    @elseif($order->status === 'paid')
                        <span style="color:#15803d;font-weight:700;">
                            <i class="fas fa-check-circle"></i>Sudah Dibayar
                        </span>
                    @else
                        <span>{{ ucfirst($order->status) }}</span>
                    @endif
                </div>
            </div>
        </div>

        {{-- ================= BUKTI PEMBAYARAN ================= --}}
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-image"></i> Bukti Pembayaran
            </h4>

            @if($order->payment_proof)
                <a href="{{ asset('storage/'.$order->payment_proof) }}" target="_blank">
                    <img
                        src="{{ asset('storage/'.$order->payment_proof) }}"
                        alt="Bukti Pembayaran"
                        style="max-width:280px;border-radius:10px;border:1px solid #ddd;"
                    >
                </a>
                <p style="font-size:12px;color:#777;margin-top:6px;">
                    Klik gambar untuk memperbesar
                </p>
            @else
                <p style="color:#999;font-style:italic;">
                    Bukti pembayaran belum diunggah oleh pelanggan.
                </p>
            @endif
        </div>

        {{-- ================= ITEM PESANAN ================= --}}
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-coffee"></i> Item yang Dipesan
            </h4>

            <div class="header-minimal header-3col">
                <span>Nama Produk</span>
                <span class="center">Jumlah</span>
                <span class="right">Total</span>
            </div>
            <div class="product-list-clean">
                @foreach($order->items as $item)
                    <div class="row-3col">
                        <span>{{ $item->product->name }}</span>
                        <span class="center">{{ $item->qty }}</span>
                        <span class="right">
                            Rp {{ number_format($item->price * $item->qty, 0, ',', '.') }}
                        </span>
                    </div>
                @endforeach
            </div>
            <div class="row-summary">
                <span>Biaya Pengiriman</span>
                <span class="right">
                    Rp {{ number_format($order->shipping_cost ?? 0, 0, ',', '.') }}
                </span>
            </div>
            <div class="row-summary total">
                <span>Total Pembayaran</span>
                <span class="right">
                    Rp {{ number_format($order->total_price, 0, ',', '.') }}
                </span>
            </div>
        </div>
        {{-- ================= DATA PENGIRIMAN ================= --}}
<div class="kopi-info-group">
    <h4 class="kopi-label-group">
        <i class="fas fa-truck"></i> Detail Pengiriman
    </h4>

    <div class="kopi-detail-list">
        <div class="detail-item">
            <strong>Penerima:</strong>
            <span>{{ $order->receiver_name }}</span>
        </div>

        <div class="detail-item">
            <strong>No. HP:</strong>
            <span>{{ $order->phone }}</span>
        </div>

        <div class="detail-item">
            <strong>Alamat:</strong>
            <span>{{ $order->address }}</span>
        </div>

        <div class="detail-item">
            <strong>Kurir:</strong>
            <span>{{ strtoupper($order->courier ?? '-') }}</span>
        </div>
        <div class="detail-item">
            <strong>Ongkir:</strong>
            <span>
                Rp {{ number_format($order->shipping_cost, 0, ',', '.') }}
            </span>
        </div>
    </div>
</div>


        {{-- ================= UPDATE STATUS ================= --}}
        <div class="kopi-info-group no-border">
            <h4 class="kopi-label-group">
                <i class="fas fa-truck"></i> Update Status & Logistik
            </h4>

            @if($order->status === 'pending' && !$order->payment_proof)
                <p style="font-size:12px;color:#b45309;margin-bottom:10px;">
                    ⚠️ Pastikan bukti pembayaran sudah diunggah sebelum mengubah status ke
                    <strong>PAID</strong>.
                </p>
            @endif

            <form method="POST" action="{{ route('admin.orders.updateStatus', $order) }}">
                @csrf
                @method('PATCH')

                <div class="kopi-field">
                    <label>Status Pesanan</label>
                    <select name="status" id="statusSelect" class="kopi-control">
                        @foreach(['pending','paid','process','shipped','completed','cancelled'] as $status)
                            <option value="{{ $status }}"
                                {{ $order->status === $status ? 'selected' : '' }}
                                @if($status === 'paid' && !$order->payment_proof) disabled @endif
                            >
                                {{ ucfirst($status) }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div id="shippingFields"
                     style="{{ $order->status === 'shipped' ? '' : 'display:none;' }}">

                    <div class="kopi-field">
                        <label>Kurir</label>
                        <input type="text" name="courier"
                               class="kopi-control"
                               value="{{ $order->courier }}">
                    </div>

                    <div class="kopi-field">
                        <label>No. Resi</label>
                        <input type="text" name="tracking_number"
                               class="kopi-control"
                               value="{{ $order->tracking_number }}">
                    </div>
                </div>

                <button type="submit" class="btn-kopi-blue">
                    Simpan Perubahan
                </button>
            </form>
        </div>

    </div>
</div>

<script>
document.getElementById('statusSelect').addEventListener('change', function () {
    document.getElementById('shippingFields').style.display =
        this.value === 'shipped' ? 'block' : 'none';
});
</script>
@endsection
