@extends('layouts.admin')

@section('title', 'Tambah Produk - Kopi Ketjeh')

@section('content')
<div class="edit-product-container">
    <div class="edit-product-card">
        {{-- Header Kartu --}}
        <div class="card-header-formal">
            <div class="header-text">
                <h3><i class="fas fa-plus-circle"></i> Tambah Produk Baru</h3>
                <p>Silakan lengkapi data untuk menambahkan koleksi produk kopi baru</p>
            </div>
            <a href="{{ route('admin.products.index') }}" class="btn-back-link">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        {{-- Form Tambah --}}
        <form action="{{ route('admin.products.store') }}" 
              method="POST" 
              enctype="multipart/form-data" 
              class="edit-form-grid">
            @csrf

            {{-- SISI KIRI: Upload & Preview Gambar --}}
            <div class="form-image-section">
                <div class="current-preview-box">
                    <label class="input-label-formal">Pratinjau Gambar</label>
                    <div class="img-wrapper">
                        {{-- Gambar default sebelum upload --}}
                        <img id="preview-display" src="{{ asset('img/placeholder-coffee.png') }}" alt="Preview" style="opacity: 0.5;">
                    </div>
                </div>
                
                <div class="input-group-custom mt-4">
                    <label for="image" class="upload-label">
                        <i class="fas fa-camera"></i> Pilih Foto Produk
                    </label>
                    <input type="file" name="image" id="image" class="hidden-file-input" onchange="previewFile(event)" required>
                    <p class="file-hint">*Format: JPG, PNG (Max 2MB)</p>
                </div>
            </div>

            {{-- SISI KANAN: Data Form --}}
            <div class="form-data-section">
                <div class="input-group-custom">
                    <label class="input-label-formal">Nama Produk</label>
                    <input name="name" 
                           type="text"
                           class="input-field-premium" 
                           placeholder="Masukkan nama kopi..." 
                           value="{{ old('name') }}"
                           required>
                </div>

                <div class="input-row-flex">
                    <div class="input-group-custom">
                        <label class="input-label-formal">Harga (Rp)</label>
                        <input name="price" 
                               type="number" 
                               class="input-field-premium" 
                               placeholder="0" 
                               value="{{ old('price') }}"
                               required>
                    </div>
                    <div class="input-group-custom">
                        <label class="input-label-formal">Stok Awal</label>
                        <input name="stock" 
                               type="number" 
                               class="input-field-premium" 
                               placeholder="0" 
                               value="{{ old('stock') }}"
                               required>
                    </div>
                </div>

                <div class="input-group-custom">
                    <label class="input-label-formal">Deskripsi Produk</label>
                    <textarea name="description" 
                              rows="4" 
                              class="textarea-field-premium" 
                              placeholder="Ceritakan karakteristik rasa dan aroma kopi ini...">{{ old('description') }}</textarea>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-update-premium">
                        <i class="fas fa-save"></i> Simpan Produk
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- Script Preview Gambar --}}
<script>
    function previewFile(event) {
        var output = document.getElementById('preview-display');
        output.src = URL.createObjectURL(event.target.files[0]);
        output.style.opacity = "1";
        output.onload = function() {
            URL.revokeObjectURL(output.src)
        }
    }
</script>
@endsection