@extends('layouts.admin')

@section('title', 'Edit Produk - Kopi Ketjeh')

@section('content')
<div class="edit-product-container">
    <div class="edit-product-card">
        {{-- Header Kartu --}}
        <div class="card-header-formal">
            <div class="header-text">
                <h3><i class="fas fa-edit"></i> Edit Produk</h3>
                <p>Perbarui informasi produk secara akurat dan detail</p>
            </div>
            <a href="{{ route('admin.products.index') }}" class="btn-back-link">
                <i class="fas fa-arrow-left"></i> Kembali
            </a>
        </div>

        {{-- Form Edit --}}
        <form action="{{ route('admin.products.update', $product) }}" 
              method="POST" 
              enctype="multipart/form-data" 
              class="edit-form-grid">
            @csrf
            @method('PUT')

            {{-- SISI KIRI: Preview & Upload Gambar --}}
            <div class="form-image-section">
                <div class="current-preview-box">
                    <label class="input-label-formal">Gambar Produk Saat Ini</label>
                    <div class="img-wrapper">
                        @if($product->image)
                            <img src="{{ asset('storage/'.$product->image) }}" id="preview-display" alt="Produk">
                        @else
                            <div class="no-image-placeholder">No Image</div>
                        @endif
                    </div>
                </div>
                
                <div class="input-group-custom mt-4">
                    <label for="image" class="upload-label">
                        <i class="fas fa-cloud-upload-alt"></i> Ganti Gambar
                    </label>
                    <input type="file" name="image" id="image" class="hidden-file-input" onchange="previewFile(event)">
                    <p class="file-hint">*Format: JPG, PNG (Max 2MB)</p>
                </div>
            </div>

            {{-- SISI KANAN: Data Teknis --}}
            <div class="form-data-section">
                <div class="input-group-custom">
                    <label class="input-label-formal">Nama Produk</label>
                    <input name="name" 
                           value="{{ $product->name }}" 
                           class="input-field-premium" 
                           placeholder="Contoh: (100gr) Signature Coffee" 
                           required>
                </div>

                <div class="input-row-flex">
                    <div class="input-group-custom">
                        <label class="input-label-formal">Harga (Rp)</label>
                        <input name="price" 
                               type="number" 
                               value="{{ $product->price }}" 
                               class="input-field-premium" 
                               placeholder="0" 
                               required>
                    </div>
                    <div class="input-group-custom">
                        <label class="input-label-formal">Stok</label>
                        <input name="stock" 
                               type="number" 
                               value="{{ $product->stock }}" 
                               class="input-field-premium" 
                               placeholder="0" 
                               required>
                    </div>
                </div>

                <div class="input-group-custom">
                    <label class="input-label-formal">Deskripsi Produk</label>
                    <textarea name="description" 
                              rows="4" 
                              class="textarea-field-premium" 
                              placeholder="Tuliskan deskripsi kopi di sini...">{{ $product->description }}</textarea>
                </div>

                <div class="form-actions">
                    <button type="submit" class="btn-update-premium">
                        <i class="fas fa-save"></i> Simpan Perubahan
                    </button>
                </div>
            </div>
        </form>
    </div>
</div>

{{-- Script Preview Gambar Sederhana --}}
<script>
    function previewFile(event) {
        var output = document.getElementById('preview-display');
        output.src = URL.createObjectURL(event.target.files[0]);
        output.onload = function() {
            URL.revokeObjectURL(output.src)
        }
    }
</script>
@endsection