@extends('layouts.admin')

@section('title', 'Kelola Produk')

@push('extra-css')
    <link rel="stylesheet" href="{{ asset('assets/css/admin-custom.css') }}">
    <style>
        /* Styling tambahan khusus halaman produk */
        .product-thumbnail {
            width: 60px;
            height: 60px;
            object-fit: cover;
            border-radius: 8px;
            border: 1px solid rgba(78, 52, 46, 0.1);
        }
        .stock-badge {
            background-color: #efebe9;
            color: #4e342e;
            padding: 4px 10px;
            border-radius: 6px;
            font-weight: 700;
            font-size: 0.85rem;
        }
        .alert-success-custom {
            background-color: #e8f5e9;
            color: #2e7d32;
            padding: 15px;
            border-radius: 10px;
            margin-bottom: 20px;
            border-left: 5px solid #2e7d32;
            font-weight: 600;
        }

        /* Revisi agar Header Responsif */
        @media (max-width: 768px) {
            .dash-header {
                flex-direction: column !important;
                align-items: flex-start !important;
                gap: 15px;
            }
            .btn-tambah {
                width: 100%;
                justify-content: center;
            }
        }
    </style>
@endpush

@section('content')
<div class="dashboard-container">
    
    {{-- HEADER HALAMAN --}}
    <div class="dash-header" style="display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px;">
        <div class="header-text">
            <h1 class="dash-title" style="color: #4e342e; font-weight: 600; margin-bottom: 5px;">Kelola Produk</h1>
            <p class="dash-sub">Atur katalog produk, harga, dan ketersediaan stok Kopi Ketjeh.</p>
        </div>
        <a href="{{ route('admin.products.create') }}" class="btn-tambah">
            <i class="fas fa-plus"></i> Tambah Produk Baru
        </a>
    </div>

    {{-- NOTIFIKASI --}}
    @if(session('success'))
        <div class="alert-success-custom">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    {{-- KONTEN PANEL --}}
    <div class="content-panel">
        {{-- REVISI: Tambahkan class table-responsive di sini --}}
        <div class="table-responsive">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th width="5%" style="text-align: center;">No</th>
                        <th width="15%">Gambar</th>
                        <th width="30%">Nama Produk</th>
                        <th width="20%">Harga</th>
                        <th width="10%" style="text-align: center;">Stok</th>
                        <th width="20%" style="text-align: center;">Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($products as $index => $product)
                    <tr>
                        <td style="text-align: center; color: #8d6e63; font-weight: bold;">
                            {{ $index + 1 }}
                        </td>
                        <td>
                            @if($product->image)
                                <img src="{{ asset('storage/'.$product->image) }}" class="product-thumbnail">
                            @else
                                <div class="product-thumbnail" style="background: #f5f5f5; display: flex; align-items: center; justify-content: center; color: #ccc;">
                                    <i class="fas fa-image fa-lg"></i>
                                </div>
                            @endif
                        </td>
                        <td>
                            <span style="font-weight: 600; color: #4e342e; font-size: 1rem;">{{ $product->name }}</span>
                        </td>
                        <td class="order-price">
                            Rp {{ number_format($product->price, 0, ',', '.') }}
                        </td>
                        <td style="text-align: center;">
                            <span class="stock-badge">{{ $product->stock }}</span>
                        </td>
                        <td style="text-align: center;">
                            <div style="display: flex; justify-content: center; gap: 15px;">
                                <a href="{{ route('admin.products.edit', $product) }}" 
                                   style="color: #1976d2; text-decoration: none; font-weight: 700; font-size: 0.85rem;">
                                    <i class="fas fa-edit"></i> EDIT
                                </a>

                                <form action="{{ route('admin.products.destroy', $product) }}" method="POST" class="inline">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" 
                                            style="color: #d32f2f; background: none; border: none; font-weight: 700; font-size: 0.85rem; cursor: pointer; padding: 0;"
                                            onclick="return confirm('Apakah Anda yakin ingin menghapus produk {{ $product->name }}?')">
                                        <i class="fas fa-trash"></i> HAPUS
                                    </button>
                                </form>
                            </div>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection