@extends('layouts.admin')

@section('title', 'Kelola User')

@section('content')
<div class="dashboard-container">
    
    {{-- HEADER HALAMAN --}}
    <div class="dash-header">
        <div class="header-text">
            <h1 class="dash-title">Kelola User</h1>
            <p class="dash-sub">Manajemen hak akses dan data pengguna terdaftar di sistem Kopi Ketjeh.</p>
        </div>
        
        {{-- Tombol Refresh Fungsional --}}
        <a href="{{ route('admin.users.index') }}" class="btn-refresh">
            <i class="fas fa-sync-alt"></i> <span>Refresh Data</span>
        </a>
    </div>

    {{-- FLASH MESSAGE --}}
    @if(session('success'))
        <div style="background: #dcfce7; color: #166534; padding: 12px; border-radius: 8px; margin-bottom: 20px; border-left: 5px solid #22c55e;">
            <i class="fas fa-check-circle"></i> {{ session('success') }}
        </div>
    @endif

    {{-- KONTEN PANEL TABEL --}}
    <div class="content-panel">
        <div class="table-responsive">
            <table class="modern-table">
                <thead>
                    <tr>
                        <th width="25%">NAMA LENGKAP</th>
                        <th width="35%">ALAMAT EMAIL</th>
                        <th width="20%" style="text-align: center;">ROLE / HAK AKSES</th>
                        <th width="20%" style="text-align: center;">AKSI</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                    <tr>
                        {{-- NAMA --}}
                        <td>
                            <div style="font-weight: 600; color: #4e342e;">{{ $user->name }}</div>
                        </td>

                        {{-- EMAIL --}}
                        <td style="color: #5d4037;">
                            {{ $user->email }}
                        </td>

                        {{-- ROLE (DROPDOWN AUTO UPDATE) --}}
                        <td style="text-align: center;">
                            <form method="POST" action="{{ route('admin.users.updateRole', $user) }}">
                                @csrf
                                @method('PATCH')
                                <select name="role" onchange="this.form.submit()" class="status-select">
                                    <option value="user" {{ $user->role === 'user' ? 'selected' : '' }}>User</option>
                                    <option value="admin" {{ $user->role === 'admin' ? 'selected' : '' }}>Admin</option>
                                </select>
                            </form>
                        </td>

                        {{-- AKSI --}}
                        <td style="text-align: center;">
                            <form action="{{ route('admin.users.destroy', $user) }}" method="POST" onsubmit="return confirm('Hapus user ini?')">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn-delete-formal">
                                    <i class="fas fa-trash-alt"></i> HAPUS 
                                </button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>

    {{-- PAGINATION --}}
    <div style="margin-top: 25px;">
        {{ $users->links() }}
    </div>
</div>
@endsection