@extends('layouts.app')

@section('title', 'Akun Saya')

@section('content')

<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">

<style>
:root{
    --kopi-dark:#4b280a;
    --kopi-accent:#7a4a2e;
    --bg:#f6f7f9;
}

body{
    background:var(--bg);
    font-family:'Nunito',sans-serif;
}

/* LAYOUT */
.akun-wrapper{
    max-width:1200px;
    margin:40px auto;
    display:grid;
    grid-template-columns:260px 1fr;
    gap:24px;
}

/* SIDEBAR */
.akun-sidebar{
    background:#fff;
    border-radius:18px;
    padding:24px;
    box-shadow:0 10px 30px rgba(0,0,0,.08);
    height:fit-content;
}

.avatar{
    width:80px;height:80px;
    border-radius:50%;
    background:var(--kopi-dark);
    color:#fff;
    font-size:32px;
    font-weight:800;
    display:flex;
    align-items:center;
    justify-content:center;
    margin:0 auto 12px;
}

.akun-sidebar h4{
    text-align:center;
    color:var(--kopi-dark);
    font-weight:800;
    margin-bottom:20px;
}

.akun-menu a{
    display:block;
    padding:12px 14px;
    border-radius:12px;
    font-weight:700;
    color:#4b280a;
    text-decoration:none;
    margin-bottom:8px;
}

/* Penyelarasan Ikon Menu */
.akun-menu a i {
    margin-right: 10px;
    width: 20px;
    text-align: center;
}

.akun-menu a:hover{
    background:#f1ede9;
}

.btn-logout{
    width:100%;
    margin-top:18px;
    padding:10px;
    border-radius:12px;
    border:1px solid #fca5a5;
    background:#fff;
    color:#991b1b;
    font-weight:700;
    cursor:pointer;
}

/* CONTENT */
.card{
    background:#fff;
    border-radius:18px;
    padding:22px;
    box-shadow:0 10px 35px rgba(0,0,0,.08);
}

.card h3{
    color:var(--kopi-dark);
    margin-bottom:18px;
}

.card h3 i {
    margin-right: 10px;
}

/* ORDER CARD */
.order-card{
    background:#fff;
    border-radius:16px;
    padding:16px;
    margin-bottom:18px;
    box-shadow:0 8px 25px rgba(0,0,0,.06);
}

.order-header{
    display:flex;
    justify-content:space-between;
    align-items:center;
    font-weight:800;
}

.status{
    font-size:12px;
    padding:6px 14px;
    border-radius:20px;
    font-weight:700;
}

.status i {
    margin-right: 5px;
}

.pending{background:#fde68a;color:#92400e;}
.warning{background:#fee2e2;color:#991b1b;}
.shipped{background:#dbeafe;color:#1e40af;}
.completed{background:#ede9fe;color:#5b21b6;}

.order-item{
    display:flex;
    gap:14px;
    margin-top:14px;
}

.order-item img{
    width:70px;height:70px;
    border-radius:12px;
    object-fit:cover;
}

.order-total{
    display:flex;
    justify-content:space-between;
    margin-top:12px;
    font-weight:800;
}

.order-box{
    margin-top:12px;
    background:#f1f5f9;
    padding:14px;
    border-radius:12px;
    font-size:13px;
}

.order-box i {
    margin-right: 8px;
}
.process {
    background:#e0f2fe;
    color:#075985;
}

.paid {
    background:#dcfce7;
    color:#166534;
}

.btn-complete{
    width:100%;
    margin-top:12px;
    background:var(--kopi-dark);
    color:#fff;
    padding:10px;
    border:none;
    border-radius:12px;
    font-weight:800;
    cursor:pointer;
    display: inline-block;
    text-align: center;
    text-decoration: none;
}
</style>

<div class="akun-wrapper">

    {{-- SIDEBAR --}}
    <aside class="akun-sidebar">
        <div class="avatar">
            {{ strtoupper(substr(auth()->user()->name,0,1)) }}
        </div>

        <h4>{{ auth()->user()->name }}</h4>

        <nav class="akun-menu">
            <a href="{{ route('profile.edit') }}"><i class="fa-regular fa-circle-user"></i> Edit Profil</a>
            <a href="{{ route('akun') }}"><i class="fa-solid fa-box"></i> Pesanan Saya</a>
        </nav>

        <form method="POST" action="{{ route('logout') }}">
            @csrf
            <button class="btn-logout">
                <i class="fa-solid fa-arrow-right-from-bracket"></i> Keluar
            </button>
        </form>
    </aside>

    {{-- CONTENT --}}
    <main>
        <div class="card">
            <h3><i class="fa-solid fa-bag-shopping"></i> Pesanan Saya</h3>

            @forelse($orders as $order)
            <div class="order-card">

                {{-- HEADER --}}
                <div class="order-header">
    <span>ORD-{{ $order->id }}</span>

    @if($order->status === 'pending')
        <span class="status pending">
            <i class="fa-solid fa-clock"></i> Menunggu Pembayaran
        </span>

    @elseif($order->status === 'waiting_verification')
        <span class="status warning">
            <i class="fa-solid fa-spinner fa-spin"></i> Verifikasi Admin
        </span>

    @elseif($order->status === 'paid')
        <span class="status warning">
            <i class="fa-solid fa-check"></i> Pembayaran Diterima
        </span>

    @elseif($order->status === 'process')
        <span class="status warning">
            <i class="fa-solid fa-box"></i> Diproses
        </span>

    @elseif($order->status === 'shipped')
        <span class="status shipped">
            <i class="fa-solid fa-truck"></i> Dikirim
        </span>

    @elseif($order->status === 'completed')
        <span class="status completed">
            <i class="fa-solid fa-check-double"></i> Selesai
        </span>
    @endif
</div>


                {{-- PRODUK --}}
                @foreach($order->items as $item)
                <div class="order-item">
                    <img src="{{ asset('storage/'.$item->product->image) }}">
                    <div>
                        <strong>{{ $item->product->name }}</strong><br>
                        Qty {{ $item->qty }} • Rp {{ number_format($item->price) }}
                    </div>
                </div>
                @endforeach

                {{-- TOTAL --}}
                <div class="order-total">
                    <span>Total</span>
                    <span>Rp {{ number_format($order->total_price) }}</span>
                </div>

                {{-- STATUS DETAIL --}}
                @if($order->status === 'pending')
                    <a href="{{ route('payment.manual', $order) }}"
                       class="btn-complete">
                        <i class="fa-solid fa-upload"></i> Upload Bukti Pembayaran
                    </a>

                @elseif($order->status === 'waiting_verification')
                    <div class="order-box">
                        <i class="fa-solid fa-circle-info"></i> Bukti pembayaran sudah dikirim, menunggu verifikasi admin
                    </div>

                @elseif($order->status === 'shipped')
                    <div class="order-box">
                        <i class="fa-solid fa-truck-fast"></i> Kurir: <strong>{{ $order->courier }}</strong><br>
                        <i class="fa-solid fa-hashtag"></i> Resi: <strong>{{ $order->tracking_number }}</strong>

                        <form method="POST"
                              action="{{ route('pesanan.selesai', $order) }}"
                              onsubmit="return confirm('Pesanan sudah diterima?')">
                            @csrf
                            @method('PATCH')

                            <button class="btn-complete">
                                <i class="fa-solid fa-handshake"></i> Pesanan Diterima
                            </button>
                        </form>
                    </div>

                @elseif($order->status === 'completed')
                    <div class="order-box" style="background: #f0fdf4; color: #166534;">
                        <i class="fa-solid fa-circle-check"></i> Pesanan telah selesai. Terima kasih!
                    </div>
                @endif

            </div>
            @empty
                <div style="text-align:center; color:#999; padding: 20px;">
                    <i class="fa-solid fa-inbox" style="font-size: 40px; margin-bottom: 10px;"></i>
                    <p>Belum ada pesanan</p>
                </div>
            @endforelse

        </div>
    </main>
</div>

@endsection