<x-guest-layout>

    <!-- HEADER BRAND -->
    <div class="text-center mb-8">
        <h1 class="text-3xl font-semibold text-coffee">
            Kopi Ketjeh
        </h1>
        <p class="mt-2 text-sm text-gray-500">
            Masuk & nikmati kopi rempah nusantara ☕
        </p>
    </div>

    <!-- FORM -->
    <form method="POST" action="{{ route('login') }}" class="space-y-5">
        @csrf

        <!-- Email / Username -->
        <div>
            <label class="label">Email atau Username</label>
            <input
                type="text"
                name="login"
                value="{{ old('login') }}"
                required
                autofocus
                class="input-premium"
                placeholder="email@contoh.com"
            >
            <x-input-error :messages="$errors->get('login')" class="mt-1" />
        </div>

        <!-- Password -->
        <div>
            <label class="label">Password</label>
            <input
                type="password"
                name="password"
                required
                class="input-premium"
                placeholder="••••••••"
            >
            <x-input-error :messages="$errors->get('password')" class="mt-1" />
        </div>

        <!-- REMEMBER + FORGOT -->
        <div class="flex items-center justify-between text-sm">
            <label class="flex items-center gap-2">
                <input type="checkbox" name="remember" class="accent-coffee">
                Ingat saya
            </label>

            @if (Route::has('password.request'))
                <a href="{{ route('password.request') }}" class="link-coffee">
                    Lupa password?
                </a>
            @endif
        </div>

        <!-- BUTTON -->
        <button type="submit" class="btn-premium">
            MASUK
        </button>
    </form>

    <!-- FOOTER CTA -->
    <div class="mt-8 text-center">
        <p class="text-sm text-gray-500">
            Belum punya akun?
        </p>

        <a href="{{ route('register') }}" class="link-register">
            Daftar Sekarang
        </a>

        <p class="mt-3 text-xs text-gray-400">
            atau <a href="{{ route('home') }}" class="underline">lihat-lihat dulu</a>
        </p>
    </div>

</x-guest-layout>
