@extends('layouts.app')

@section('title', 'Keranjang')

@section('content')
<div class="cart-wrapper">

    <h2 class="cart-title">Keranjang Belanja</h2>

    <div class="cart-card">

        @if(count($cart) === 0)
            <div class="cart-empty">
                Keranjang belanja kamu masih kosong ☕
            </div>
        @else
            <table class="cart-table">
                <thead>
                    <tr>
                        <th>Produk</th>
                        <th>Harga</th>
                        <th>Qty</th>
                        <th>Subtotal</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($cart as $productId => $item)
                    <tr data-id="{{ $productId }}">
                        <td class="cart-name">{{ $item['name'] }}</td>

                        <td>Rp {{ number_format($item['price']) }}</td>

                        <td>
                            <div class="qty-control">
                                <button class="qty-btn minus">−</button>
                                <input
                                    type="number"
                                    class="qty-input"
                                    value="{{ $item['qty'] }}"
                                    min="1">
                                <button class="qty-btn plus">+</button>
                            </div>
                        </td>

                        <td class="cart-subtotal">
                            Rp {{ number_format($item['price'] * $item['qty']) }}
                        </td>

                        <td>
                            <button class="remove-btn">
                                Hapus
                            </button>
                        </td>
                    </tr>
                @endforeach
                </tbody>
            </table>

            <div class="cart-summary">
                <div class="cart-total">
                    Total: <span id="total">Rp {{ number_format($total) }}</span>
                </div>

                {{-- 🔥 PERBAIKAN INTI (POST BUKAN GET) --}}
                <form action="{{ route('cart.checkout') }}" method="POST">
                    @csrf
                    <button type="submit" class="checkout-link">
                        Checkout
                    </button>
                </form>

            </div>
        @endif

    </div>
</div>

{{-- CSRF --}}
<meta name="csrf-token" content="{{ csrf_token() }}">

{{-- SCRIPT (LOGIKA TETAP PUNYAMU – TIDAK DIUBAH) --}}
<script>
const csrf = document.querySelector('meta[name="csrf-token"]').content;

function updateCart(id, qty, row) {
    fetch(`/cart/update/${id}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrf
        },
        body: JSON.stringify({ qty })
    })
    .then(res => res.json())
    .then(data => {
        row.querySelector('.cart-subtotal').innerText = data.subtotal;
        document.getElementById('total').innerText = data.total;
    });
}

document.querySelectorAll('.qty-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        const row = btn.closest('tr');
        const input = row.querySelector('.qty-input');
        let qty = parseInt(input.value);

        if (btn.classList.contains('plus')) qty++;
        if (btn.classList.contains('minus') && qty > 1) qty--;

        input.value = qty;
        updateCart(row.dataset.id, qty, row);
    });
});

document.querySelectorAll('.qty-input').forEach(input => {
    input.addEventListener('change', () => {
        const row = input.closest('tr');
        let qty = Math.max(1, parseInt(input.value) || 1);
        input.value = qty;
        updateCart(row.dataset.id, qty, row);
    });
});

document.querySelectorAll('.remove-btn').forEach(btn => {
    btn.addEventListener('click', () => {
        const row = btn.closest('tr');
        const id = row.dataset.id;

        fetch(`/cart/remove/${id}`, {
            method: 'POST',
            headers: { 'X-CSRF-TOKEN': csrf }
        })
        .then(res => res.json())
        .then(data => {
            row.remove();
            document.getElementById('total').innerText = data.total;
            if (data.empty) location.reload();
        });
    });
});
</script>
@endsection
