@extends('layouts.app')

@section('title', 'Checkout')

@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">

<div class="checkout-page">
<form action="{{ route('checkout.pay') }}" method="POST" onsubmit="return disableBtn()">
@csrf

{{-- ================= DATA PENERIMA ================= --}}
<section class="checkout-box">
    <h4>Data Penerima</h4>

    <input type="text"
           name="receiver_name"
           placeholder="Nama Penerima"
           required>

   <input type="tel"
       name="phone"
       id="phone"
       placeholder="08xxxxxxxxxx"
       required
       inputmode="numeric"
       pattern="^08[0-9]{8,11}$"
       title="Nomor HP harus angka dan diawali 08">

</section>

{{-- ================= ALAMAT ================= --}}
<section class="checkout-box">
    <h4>Alamat Tujuan</h4>

    <input type="text"
        id="alamat_search"
        placeholder="Ketik kecamatan / kota (contoh: Diwek, Jombang)"
        autocomplete="off"
        required>

    <select id="area_result"
            size="5"
            style="display:none;width:100%;margin-top:6px">
    </select>

    <textarea name="address"
        placeholder="Nama jalan, RT/RW, patokan rumah"
        required></textarea>

    <input type="hidden" name="destination_area_id" id="area_id">
</section>

{{-- ================= KURIR ================= --}}
<section class="checkout-box">
    <h4>Pilih Kurir</h4>

    <select id="courier" required>
        <option value="">-- Pilih Kurir --</option>
        <option value="jne">JNE</option>
        <option value="jnt">J&T</option>
        <option value="sicepat">SiCepat</option>
    </select>

    <select id="service" required>
        <option value="">-- Pilih Layanan --</option>
    </select>
</section>

{{-- ================= METODE BAYAR ================= --}}
<section class="checkout-box">
    <h4>Metode Pembayaran</h4>

    <select name="payment_channel" required>
        <option value="">-- Pilih Metode --</option>
        <option value="bank">Transfer Bank</option>
        <option value="ewallet">E-Wallet</option>
    </select>

    <select name="payment_name" required>
        <option value="">-- Pilih Bank / E-Wallet --</option>
        <option value="BRI">BRI</option>
        <option value="DANA">DANA</option>
    </select>
</section>

{{-- ================= PRODUK ================= --}}
<section class="checkout-box">
    <h4>Produk Dipesan</h4>

    @foreach($checkoutCart as $productId => $item)
    <div class="product-row">
        <img src="{{ asset('storage/'.$item['image']) }}" alt="" width="60">

        <div class="product-info">
            <div>{{ $item['name'] }}</div>
            <div>Rp {{ number_format($item['price']) }}</div>
        </div>

        <div class="qty-control">
            <button type="button" onclick="changeQty({{ $productId }},-1)">−</button>
            <span id="qty-{{ $productId }}">{{ $item['qty'] }}</span>
            <button type="button" onclick="changeQty({{ $productId }},1)">+</button>
        </div>
    </div>
    @endforeach
</section>

{{-- ================= RINGKASAN ================= --}}
<section class="checkout-box">
    <div>Subtotal <span id="subtotal_text">Rp {{ number_format($subtotal) }}</span></div>
    <div>Ongkir <span id="ongkir_text">Rp 0</span></div>
    <strong>Total <span id="total_text">Rp {{ number_format($subtotal) }}</span></strong>
</section>

{{-- ================= HIDDEN ================= --}}
<input type="hidden" name="shipping_cost" id="shipping_cost">
<input type="hidden" name="full_address" id="full_address">
<input type="hidden" name="total_price" id="total_price" value="{{ $subtotal }}">
<input type="hidden" name="courier" id="courier_input">
<input type="hidden" name="courier_service" id="courier_service">

<button id="payBtn" type="submit">
    Buat Pesanan • Rp {{ number_format($subtotal) }}
</button>

</form>
</div>

{{-- ================= SCRIPT ================= --}}
<script>
const csrf = document.querySelector('meta[name="csrf-token"]').content;
let subtotal = {{ $subtotal }};
let pricingData = [];

/* ================= SEARCH AREA ================= */
const alamatInput = document.getElementById('alamat_search');
const areaBox     = document.getElementById('area_result');
const areaIdInput = document.getElementById('area_id');

alamatInput.addEventListener('input', async function () {
    if (this.value.length < 3) return;

    const res  = await fetch(`/search-area?q=${this.value}`);
    const data = await res.json();

    areaBox.innerHTML = '';
    areaBox.style.display = 'block';

    if (!data.areas) return;

    data.areas.forEach(a => {
        areaBox.innerHTML += `<option value="${a.id}">${a.name}</option>`;
    });
});

areaBox.addEventListener('change', function () {
    const opt = this.options[this.selectedIndex];
    alamatInput.value = opt.text;
    areaIdInput.value = opt.value;
    areaBox.style.display = 'none';
    resetOngkir();
});

/* ================= FULL ADDRESS ================= */
function updateFullAddress() {
    const city   = alamatInput.value;
    const detail = document.querySelector('textarea[name="address"]').value;

    document.getElementById('full_address').value =
        city + ', ' + detail;
}

/* ================= UPDATE QTY ================= */
async function changeQty(productId, delta) {
    const qtyEl = document.getElementById('qty-' + productId);
    let currentQty = parseInt(qtyEl.innerText);
    let newQty = currentQty + delta;

    if (newQty < 1) return;

    const res = await fetch(`/checkout/update-qty/${productId}`, {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrf
        },
        body: JSON.stringify({ qty: newQty })
    });

    const data = await res.json();
    if (data.error) return;

    qtyEl.innerText = data.qty;
    subtotal = Number(data.subtotal);

    document.getElementById('subtotal_text').innerText =
        'Rp ' + subtotal.toLocaleString();

    resetOngkir();
}

/* ================= TOTAL QTY ================= */
function getTotalQty() {
    let total = 0;
    document.querySelectorAll('[id^="qty-"]').forEach(el => {
        total += parseInt(el.innerText);
    });
    return total;
}

/* ================= ONGKIR ================= */
document.getElementById('courier').addEventListener('change', hitungOngkir);
document.getElementById('service').addEventListener('change', updateService);

async function hitungOngkir() {
    const area    = areaIdInput.value;
    const courier = document.getElementById('courier').value;

    if (!area || !courier) return;

    const res = await fetch('/ongkir/rates', {
        method: 'POST',
        headers: {
            'Content-Type': 'application/json',
            'X-CSRF-TOKEN': csrf
        },
        body: JSON.stringify({
            destination_area_id: area,
            weight: 1000,
            courier: courier,
            qty: getTotalQty()
        })
    });

    const data = await res.json();
    if (!data.pricing || data.pricing.length === 0) {
        alert('Layanan tidak tersedia');
        return;
    }

    pricingData = data.pricing;

    const service = document.getElementById('service');
    service.innerHTML = '<option value="">-- Pilih Layanan --</option>';

    data.pricing.forEach((p, i) => {
        service.innerHTML += `
            <option value="${i}">
                ${p.service_name} (${p.duration}) - Rp ${p.price.toLocaleString()}
            </option>
        `;
    });
}

function updateService() {
    const idx = document.getElementById('service').value;
    if (idx === '') return;

    const p = pricingData[idx];
    const total = subtotal + p.price;

    document.getElementById('ongkir_text').innerText =
        'Rp ' + p.price.toLocaleString();

    document.getElementById('total_text').innerText =
        'Rp ' + total.toLocaleString();

    document.getElementById('payBtn').innerText =
        'Buat Pesanan • Rp ' + total.toLocaleString();

    document.getElementById('shipping_cost').value = p.price;
    document.getElementById('total_price').value   = total;

    document.getElementById('courier_input').value =
        document.getElementById('courier').value;

    document.getElementById('courier_service').value =
        p.service_name;
}

function resetOngkir() {
    document.getElementById('service').innerHTML =
        '<option value="">-- Pilih Layanan --</option>';

    document.getElementById('ongkir_text').innerText = 'Rp 0';
    document.getElementById('total_text').innerText =
        'Rp ' + subtotal.toLocaleString();

    document.getElementById('shipping_cost').value = '';
    document.getElementById('total_price').value   = subtotal;

    document.getElementById('payBtn').innerText =
        'Buat Pesanan • Rp ' + subtotal.toLocaleString();
}

/* ================= SUBMIT ================= */
function disableBtn() {
    updateFullAddress();

    if (!document.getElementById('shipping_cost').value) {
        alert('Silakan pilih alamat dan layanan pengiriman');
        return false;
    }

    payBtn.disabled = true;
    payBtn.innerText = 'Memproses...';
    return true;
}
document.getElementById('phone').addEventListener('input', function () {
    // Hapus semua selain angka
    this.value = this.value.replace(/[^0-9]/g, '');
});
</script>

@endsection
