@extends('layouts.app')

@section('title', 'Kopi Ketjeh Rempah')

@section('content')

<!-- ================= HERO ================= -->
<section id="home" class="hero">
    <div class="hero-text">
        <p class="tagline">Welcome!</p>
        <h1>
            We craft coffee infused with authentic
            <span>Indonesian spices!</span>
        </h1>
        <p class="desc">
            A bold aroma, a rich taste, and a story in every sip.
        </p>
        <a href="#menu" class="btn-order">Order Now</a>
    </div>
</section>

<!-- ================= MENU ================= -->
<section id="menu" class="our-coffee">
    <h2 class="section-title">Our Coffee Menu</h2>

    <div class="menu-grid">
        @foreach($products as $product)
        <div class="coffee-card">

            <div class="coffee-img">
                <img src="{{ asset('storage/'.$product->image) }}" alt="{{ $product->name }}">
            </div>

            <div class="coffee-body">
                <h3>{{ $product->name }}</h3>
                <p class="desc">{{ $product->description }}</p>

                <p class="stock">
                    Stok:
                    @if($product->stock > 0)
                        {{ $product->stock }}
                    @else
                        <span class="text-danger">Habis</span>
                    @endif
                </p>

                <div class="coffee-bottom">
                    <span class="price">
                        Rp {{ number_format($product->price) }}
                    </span>

                    <div class="action-buttons" style="display: flex; align-items: center; gap: 10px;">
                        {{-- ===== TOMBOL ORDER ===== --}}
                        @guest
                            <a href="{{ route('login') }}" class="btn-order">
                                Order Now
                            </a>
                        @endguest

                        @auth
                            @if($product->stock > 0)
                                <button
                                    type="button"
                                    class="btn-order"
                                    onclick="openOrderModal({{ $product->id }}, '{{ $product->name }}')">
                                    Order Now
                                </button>

                                {{-- ===== TOMBOL KERANJANG (Hanya muncul jika stok ada & Auth) ===== --}}
                                <form action="{{ route('cart.add', $product->id) }}" method="POST" class="cart-form" style="margin: 0;">
                                    @csrf
                                    <button type="submit" class="cart-btn-simple">
                                        <i class="fa-solid fa-cart-shopping"></i>
                                    </button>
                                </form>
                            @else
                                <button class="btn-order" disabled>
                                    Stok Habis
                                </button>
                            @endif
                        @endauth
                    </div>
                </div>
            </div>
        </div>
        @endforeach
    </div>
</section>

<!-- ================= ORDER MODAL ================= -->
<div id="orderModal" class="order-modal hidden">
    <div class="order-modal-content">
        <button class="close-modal" onclick="closeOrderModal()">
            <i class="fas fa-times"></i>
        </button>
        
        <h3 id="orderTitle">Pilih Metode Pemesanan</h3>

        <a id="waLink" target="_blank" class="order-option">
            <i class="fab fa-whatsapp"></i> WhatsApp
        </a>

        <a id="shopeeLink" target="_blank" class="order-option">
            <i class="fas fa-shopping-bag"></i> Shopee
        </a>

        <form id="webCheckoutForm" method="POST">
            @csrf
            <button type="submit" class="order-option primary">
                <i class="fas fa-globe"></i> Website 
            </button>
        </form>
    </div>
</div>

<section id="about" class="why-banner">
    <div class="why-content">
        <h2>Kenapa Memilih Kopi Ketjeh?</h2>
        <p>
            Kopi Ketjeh bukan sekadar kopi, tapi pengalaman rasa. 
            Perpaduan kopi pilihan dan rempah Nusantara berkualitas menghadirkan cita rasa yang unik dan hangat.
        </p>
    </div>

    @php
    $rempah = [
        ['img'=>'kopi.jpeg','title'=>'100% Natural Coffee','desc'=>'Terbuat dari kopi asli tanpa bahan kimia, pengawet, atau pewarna buatan.'],
        ['img'=>'jahe.jpg','title'=>'Jahe Merah','desc'=>'Kopi mengandung rempah jahe merah yang memiliki sifat antioksidan serta anti-inflamasi yang baik untuk kesehatan.'],
        ['img'=>'kapulaga.jpg','title'=>'Kapulaga','desc'=>'Kopi mengandung rempah kapulaga yang banyak manfaat serta menambah aroma dan rasa khas.'],
        ['img'=>'cengkeh.jpg','title'=>'Cengkeh','desc'=>'Kopi mengandung rempah Cengkeh yang memberikan khasiat kesehatan meningkatkan daya tahan tubuh.'],
        ['img'=>'kayu manis.jpeg','title'=>'Kayu Manis','desc'=>'Kopi mengandung Kayu Manis bermanfaat untuk menambah antioksidan dan anti-inflamasi untuk tubuh.'],
    ];
    @endphp

    <div class="rempah-wrapper">
        @foreach($rempah as $item)
        <div class="rempah-card">
            <div class="rempah-img">
                <img src="{{ asset('images/' . $item['img']) }}" 
                    alt="{{ $item['title'] }}" 
                    loading="lazy">
            </div>
            <div class="rempah-info">
                <h3>{{ $item['title'] }}</h3>
                <p>{{ $item['desc'] }}</p>
            </div>
        </div>
        @endforeach
    </div>

    <a href="https://wa.me/6287790423998?text=Halo%20Admin%20Kopi%20Ketjeh,%20saya%20ingin%20bertanya..." 
       class="floating-wa" 
       target="_blank">
        <i class="fa-brands fa-whatsapp"></i>
    </a>
</section>

<!-- ================= COME JOIN ================= -->
<section class="comejoin">
    <div class="join-card">
        <div class="join-image">
            <img src="{{ asset('images/gambar1.png') }}" alt="Join Us Kopi Ketjeh">
        </div>
        
        <div class="join-text">
            <p class="join-script">Come Join Us</p>
            <h2 class="join-title">And Enjoy You're Ketjeh!</h2>
        </div>
    </div>
</section>

<!-- ================= FOOTER ================= -->
<footer class="footer-new">
    <div class="footer-inner">
        <div class="footer-col brand" style="max-width: 250px;">
            <h3 style="font-size: 1.5rem; font-weight: 800; line-height: 1.1; margin-bottom: 5px; color: #fff; text-transform: uppercase;">
                KOPI KETJEH<br>REMPAH
            </h3>
        </div>

        <div class="footer-col">
            <h4>Menu</h4>
            <ul class="footer-links">
                <li><a href="#home">Home</a></li>
                <li><a href="#menu">Menu</a></li>
                <li><a href="#about">About us</a></li>
            </ul>
        </div>

        <div class="footer-col About">
            <h4>About</h4>
            <p><i class="fa-solid fa-phone"></i> +62 87790423998</p>
            <p><i class="fa-solid fa-location-dot"></i> Jombang, Jawa Timur</p>
        </div>

        <div class="footer-col social">
            <h4>Social</h4>
            <p><a href="https://shopee.co.id/kopiketjeh.id" target="_blank"><i class="fa-brands fa-shopify"></i> Shopee</a></p>
            <p><a href="https://www.instagram.com/kopiketjeh.id" target="_blank"><i class="fa-brands fa-instagram"></i> Instagram</a></p>
            <p><a href="https://www.tiktok.com/@kopiketjeh.id" target="_blank"><i class="fa-brands fa-tiktok"></i> Tiktok</a></p>
        </div>

        <div class="footer-highlight">
            <div class="highlight-content">
                <i class="fa-solid fa-mug-hot"></i>
                <h3>Have You Found Your Dream Coffee?</h3>
                <p>Try our coffee, you can find the taste of your dream coffee here</p>
            </div>
        </div>
    </div>

    <div class="footer-bottom">
        <p>&copy; 2025 Kopi Rempah Ketjeh. All Rights Reserved.</p>
    </div>
</footer>

<script>

</script>

@endsection