<nav class="nav-container">
    <div class="nav-wrapper">
        
        {{-- BAGIAN KIRI: BRAND --}}
        <div class="nav-brand-section">
            <a href="{{ route('admin.dashboard') }}" class="nav-logo">
                Kopi Ketjeh
            </a>
        </div>

        {{-- TOMBOL HAMBURGER (Hanya muncul di HP via CSS) --}}
        <div class="menu-toggle" id="hamburger-btn">
            <i class="fas fa-bars"></i>
        </div>

        {{-- BAGIAN TENGAH: MENU (ID ditambahkan untuk fungsi JS) --}}
        <div class="nav-menu-section" id="nav-menu-content">
            <a href="{{ route('admin.dashboard') }}" class="{{ request()->routeIs('admin.dashboard') ? 'active' : '' }}">
                Dashboard
            </a>
            <a href="{{ route('admin.products.index') }}" class="{{ request()->routeIs('admin.products.*') ? 'active' : '' }}">
                Kelola Produk
            </a>
            <a href="{{ route('admin.orders.index') }}" class="{{ request()->routeIs('admin.orders.*') ? 'active' : '' }}">
                Kelola Pesanan
            </a>
            <a href="{{ route('admin.users.index') }}" class="{{ request()->routeIs('admin.users.*') ? 'active' : '' }}">
                Kelola User
            </a>

            {{-- Logout khusus muncul di dalam menu Hamburger (Mobile) --}}
            <div class="mobile-logout-only">
                <hr style="border: 0; border-top: 1px solid rgba(78, 52, 46, 0.1); margin: 15px 0;">
                <form method="POST" action="{{ route('logout') }}" style="margin: 0;">
                    @csrf
                    <button type="submit" class="logout-link" style="background: none; border: none; width: 100%; justify-content: flex-start; padding: 0;">
                        <i class="fas fa-sign-out-alt"></i> Logout
                    </button>
                </form>
            </div>
        </div>

        {{-- BAGIAN KANAN: USER & LOGOUT --}}
        <div class="nav-user-section">
            <div class="user-info">
                <i class="fas fa-user-circle"></i>
                <span>Admin</span>
            </div>
            <form method="POST" action="{{ route('logout') }}" style="margin: 0;">
                @csrf
                <button type="submit" class="logout-link">
                    <i class="fas fa-sign-out-alt"></i> 
                    <span>Logout</span> {{-- REVISI: Tambahkan span di sini --}}
                </button>
            </form>
        </div>
    </div>
</nav>

{{-- SCRIPT UNTUK MENGAKTIFKAN MENU PADA HP --}}
<script>
    document.addEventListener('DOMContentLoaded', function() {
        const btn = document.getElementById('hamburger-btn');
        const menu = document.getElementById('nav-menu-content');

        btn.addEventListener('click', function() {
            // Menambah/melepas class 'active' pada menu
            menu.classList.toggle('active');
            
            // Mengubah ikon bars menjadi X saat terbuka
            const icon = btn.querySelector('i');
            if (menu.classList.contains('active')) {
                icon.classList.replace('fa-bars', 'fa-times');
            } else {
                icon.classList.replace('fa-times', 'fa-bars');
            }
        });

        // Menutup menu jika user mengklik di luar menu
        document.addEventListener('click', function(event) {
            if (!btn.contains(event.target) && !menu.contains(event.target)) {
                menu.classList.remove('active');
                btn.querySelector('i').classList.replace('fa-times', 'fa-bars');
            }
        });
    });
</script>