<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>@yield('title', 'Kopi Ketjeh')</title>

    <link rel="stylesheet" href="{{ asset('assets/css/style.css') }}">
    <link rel="stylesheet"
          href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@700;800&family=Qwitcher+Grypen:wght@700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.2/css/all.min.css">
</head>

<body>

<header class="header">
    <div class="logo">
        <h2>Kopi <span>Ketjeh</span></h2>
    </div>

    <nav>
        <ul>
            <li>
                <a href="{{ route('home') }}">
                    <i class="fas fa-house"></i>
                    <span>Home</span>
                </a>
            </li>

            <li>
                <a href="{{ url('/#menu') }}">
                    <i class="fas fa-mug-hot"></i>
                    <span>Menu</span>
                </a>
            </li>

            <li>
                <a href="{{ url('/#about') }}">
                    <i class="fas fa-info-circle"></i>
                    <span>About</span>
                </a>
            </li>

            <li>
                <a href="{{ route('cart.index') }}" class="cart-link">
                    <i class="fas fa-cart-shopping"></i>
                    <span>Cart</span>
                </a>
            </li>

            <li>
                <a href="{{ route('akun') }}">
                    <i class="fas fa-user"></i>
                    <span>Saya</span>
                </a>
            </li>
        </ul>
    </nav>
</header>

{{-- ================= CONTENT ================= --}}
@yield('content')

{{-- ================= CART BADGE ================= --}}
<script>
function refreshCartBadge() {
    fetch('/cart/count')
        .then(res => res.json())
        .then(data => {
            const cartIcon = document.querySelector('.fa-cart-shopping');
            if (!cartIcon) return;

            let badge = document.getElementById('cart-badge');
            cartIcon.parentElement.style.position = 'relative';

            if (data.count > 0) {
                if (!badge) {
                    badge = document.createElement('span');
                    badge.id = 'cart-badge';
                    badge.style.cssText = `
                        position:absolute;
                        top:-6px;
                        right:-10px;
                        background:#dc2626;
                        color:#fff;
                        font-size:11px;
                        width:18px;
                        height:18px;
                        display:flex;
                        align-items:center;
                        justify-content:center;
                        border-radius:50%;
                        font-weight:bold;
                    `;
                    cartIcon.parentElement.appendChild(badge);
                }
                badge.innerText = data.count;
            } else {
                if (badge) badge.remove();
            }
        })
        .catch(err => console.error('Cart badge error:', err));
}

document.addEventListener('DOMContentLoaded', refreshCartBadge);
</script>

{{-- ================= ORDER MODAL SCRIPT ================= --}}
<script>
function openOrderModal(productId, productName) {
    document.getElementById('orderTitle').innerText =
        `Order ${productName}`;

    document.getElementById('waLink').href =
        `https://wa.me/6287790423998?text=Halo,%20saya%20ingin%20order%20${encodeURIComponent(productName)}`;

    document.getElementById('shopeeLink').href =
        'https://shopee.co.id/kopiketjeh.id', '_blank';

    document.getElementById('webCheckoutForm').action =
        `/checkout/now/${productId}`;

    document.getElementById('orderModal').classList.remove('hidden');
}

function closeOrderModal() {
    document.getElementById('orderModal').classList.add('hidden');
}
</script>

</body>
</html>
