<nav x-data="{ open: false }"
     class="fixed top-0 left-0 w-full z-50 bg-white/80 backdrop-blur-md shadow-sm">

    <div class="max-w-7xl mx-auto px-6">
        <div class="h-20 flex items-center justify-between">

            {{-- LOGO --}}
            <div class="flex items-center gap-3">
                <img src="{{ asset('images/logo.png') }}" class="h-12" alt="Kopi Ketjeh">
                <div class="leading-tight">
                    <span class="block font-bold text-gray-900">Kopi Ketjeh</span>
                    <span class="text-sm text-gray-600">Rempah</span>
                </div>
            </div>

            {{-- MENU DESKTOP --}}
            <div class="hidden md:flex items-center gap-8 font-medium text-gray-800">
                <a href="{{ route('home') }}" class="hover:underline">Home</a>
                <a href="{{ url('/#menu') }}" class="hover:underline">Menu</a>
                <a href="{{ url('/#about') }}" class="hover:underline">About</a>
            </div>

            {{-- RIGHT ACTIONS --}}
            <div class="flex items-center gap-6">

                {{-- CART ICON (DESKTOP) --}}
                <a href="{{ route('cart.index') }}" class="relative hidden md:block">
                    <i class="fas fa-cart-shopping text-xl"></i>

                    @if(cartCount() > 0)
                        <span id="cart-badge"
                              class="absolute -top-2 -right-3
                                     bg-red-600 text-white text-xs
                                     w-5 h-5 flex items-center justify-center
                                     rounded-full font-bold">
                            {{ cartCount() }}
                        </span>
                    @endif
                </a>

                {{-- AUTH --}}
                @auth
                    <x-dropdown align="right" width="48">
                        <x-slot name="trigger">
                            <button class="font-semibold flex items-center gap-1">
                                {{ Auth::user()->name }}
                                <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                          d="M19 9l-7 7-7-7"/>
                                </svg>
                            </button>
                        </x-slot>

                        <x-slot name="content">
                            <x-dropdown-link href="{{ route('profile.edit') }}">
                                Profil
                            </x-dropdown-link>

                            <x-dropdown-link href="#">
                                Status Pesanan
                            </x-dropdown-link>

                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <x-dropdown-link href="{{ route('logout') }}"
                                    onclick="event.preventDefault(); this.closest('form').submit();">
                                    Logout
                                </x-dropdown-link>
                            </form>
                        </x-slot>
                    </x-dropdown>
                @else
                    <a href="{{ route('login') }}" class="font-semibold hover:underline">
                        Login
                    </a>
                @endauth

                {{-- MOBILE BUTTON --}}
                <button @click="open = !open" class="md:hidden text-2xl">
                    ☰
                </button>
            </div>

        </div>
    </div>

    {{-- MOBILE MENU --}}
    <div x-show="open" x-transition class="md:hidden bg-white border-t shadow-sm">
        <div class="px-6 py-4 space-y-3">

            <a href="{{ route('home') }}" class="block">Home</a>
            <a href="{{ url('/#menu') }}" class="block">Menu</a>
            <a href="{{ url('/#about') }}" class="block">About</a>

            {{-- CART MOBILE --}}
            <a href="{{ route('cart.index') }}"
               class="flex items-center justify-between font-semibold">
                Keranjang
                @if(cartCount() > 0)
                    <span class="bg-red-600 text-white text-xs px-2 py-1 rounded-full">
                        {{ cartCount() }}
                    </span>
                @endif
            </a>

            @guest
                <a href="{{ route('login') }}" class="block font-semibold">Login</a>
            @endguest
        </div>
    </div>
</nav>
