@extends('layouts.app')

@section('title', 'Menunggu Pembayaran')

@section('content')

<style>
:root{
    --kopi-dark:#4b3228;
    --kopi-light:#f8f5f2;
    --kopi-accent:#7a4a2e;
}

.payment-waiting{
    max-width:520px;
    margin:40px auto;
    background:#fff;
    border-radius:16px;
    padding:28px 26px;
    box-shadow:0 10px 30px rgba(0,0,0,.08);
}

.payment-waiting h2{
    color:var(--kopi-dark);
    font-weight:800;
    text-align:center;
    margin-bottom:10px;
}

.payment-waiting p{
    font-size:14px;
    color:#555;
    text-align:center;
}

.payment-info{
    background:var(--kopi-light);
    border:1px dashed var(--kopi-accent);
    border-radius:12px;
    padding:16px;
    margin:20px 0;
}

.payment-info p{
    margin:6px 0;
    font-size:14px;
    color:#3a2a22;
    text-align:left;
}

.upload-box{
    margin-top:20px;
}

.upload-box label{
    font-size:13px;
    font-weight:700;
    color:var(--kopi-dark);
    display:block;
    margin-bottom:6px;
}

.upload-box input[type=file]{
    width:100%;
    padding:10px;
    border:1px solid #ddd;
    border-radius:8px;
}

.upload-box button{
    width:100%;
    margin-top:14px;
    padding:12px;
    background:var(--kopi-dark);
    color:#fff;
    border:none;
    border-radius:10px;
    font-weight:800;
    cursor:pointer;
}

.payment-note{
    display:block;
    margin-top:16px;
    font-size:12px;
    color:#777;
    text-align:center;
}
</style>

<div class="payment-waiting">

    <h2>⏳ Menunggu Pembayaran</h2>

    <p>
        Pesanan <strong>#ORD-{{ $order->id }}</strong> berhasil dibuat.<br>
        Silakan lakukan pembayaran sesuai metode di bawah ini.
    </p>

    {{-- INFO PEMBAYARAN --}}
    <div class="payment-info">
        <p><strong>Metode:</strong> {{ strtoupper($order->payment_channel) }}</p>

        @if($order->payment_name === 'DANA')
            <p><strong>DANA:</strong> 0858-5985-7140</p>
        @elseif($order->payment_name === 'BRI')
            <p><strong>BRI:</strong> 6417-0104-3787-531</p>
        @endif

        <p><strong>Atas Nama:</strong> Kopi Rempah Ketjeh</p>
        <p><strong>Total:</strong> Rp {{ number_format($order->total_price) }}</p>
    </div>

    {{-- UPLOAD BUKTI --}}
    @if(!$order->payment_proof)
        <form method="POST"
              enctype="multipart/form-data"
              action="{{ route('payment.manual.upload', $order) }}"
              class="upload-box">
            @csrf

            <label>Upload Bukti Pembayaran</label>
            <input type="file" name="payment_proof" required>

            <button type="submit">Kirim Bukti Pembayaran</button>
        </form>
    @else
        <div class="payment-info">
            <p style="font-weight:700;color:#7a4a2e">
                ✅ Bukti pembayaran sudah diunggah
            </p>
            <p>Status: <strong>Menunggu Verifikasi Admin</strong></p>
        </div>
    @endif

    <small class="payment-note">
        Pesanan akan diproses setelah admin melakukan verifikasi pembayaran.
    </small>

</div>
@endsection
