@extends('layouts.app')

@section('title', 'Edit Profil - Kopi Ketjeh')

@section('content')

<style>
    :root {
        --kopi-dark: #4b280a;
        --kopi-medium: #5d4037;
        --bg-body: #f8f9fa;
        --white: #ffffff;
        --danger-red: #e21212;
    }

    body {
        background-color: var(--bg-body);
        font-family: 'Nunito', sans-serif;
    }

    .profile-wrapper {
        max-width: 800px;
        margin: auto;
        padding: 2.5rem 1.5rem;
    }

    .back-link {
        text-decoration: none;
        color: var(--kopi-dark);
        font-weight: 700;
        display: inline-flex;
        align-items: center;
        gap: 8px;
        margin-bottom: 1.5rem;
    }

    .header-title {
        margin-bottom: 2rem;
        color: var(--kopi-dark);
        font-weight: 800;
        font-size: 1.8rem;
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .card {
        background: var(--white);
        border-radius: 15px;
        overflow: hidden;
        border: 1px solid #eee;
        box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
        margin-bottom: 2.5rem;
    }

    .card-header-kopi {
        background-color: var(--kopi-dark);
        color: white;
        padding: 1.2rem 1.5rem;
    }

    .card-danger .card-header-kopi {
        background-color: var(--danger-red);
    }

    .card-header-kopi h3 {
        margin: 0;
        font-size: 1.3rem;
        font-weight: 800;
        display: flex;
        align-items: center;
        gap: 15px;
    }

    .card-body-kopi {
        padding: 2rem;
    }

    /* =================================================
       BAGIAN DESKRIPSI (DIBUAT BERJARAK JAUH)
    ================================================= */
    .section-desc {
        font-size: 0.95rem;
        color: #666;
        line-height: 1.6;
        display: block;
        /* TAMBAHKAN JARAK DI SINI */
        margin-top: 10px;
        /* Jarak dari Judul ke Deskripsi */
        margin-bottom: 2.5rem;
        /* Jarak dari Deskripsi ke Form di bawahnya */
        padding-left: 2px;
    }

    /* Khusus teks peringatan merah agar lebih menonjol */
    .card-danger .section-desc {
        color: var(--danger-red) !important;
        font-weight: 600;
        background-color: #fff5f5;
        /* Background merah muda tipis agar tidak mepet visual */
        padding: 15px;
        border-radius: 8px;
        border-left: 4px solid var(--danger-red);
    }

    .card-body-kopi form {
        display: flex !important;
        flex-direction: column !important;
        gap: 1.2rem !important;
    }

    .card-body-kopi label {
        font-size: 0.8rem;
        font-weight: 800;
        color: #444;
        text-transform: uppercase;
        margin-bottom: 8px !important;
        display: block;
    }

    .card-body-kopi input {
        width: 100% !important;
        padding: 12px !important;
        border: 1px solid #ddd !important;
        border-radius: 10px !important;
        background: #fdfdfd !important;
    }

    .card-body-kopi button {
        background-color: var(--kopi-dark) !important;
        color: white !important;
        padding: 12px 30px !important;
        border-radius: 10px !important;
        font-weight: 800 !important;
        border: none !important;
        cursor: pointer;
        width: fit-content;
    }

    .card-danger button {
        background-color: var(--danger-red) !important;
    }
</style>

<div class="profile-wrapper">

    <a href="{{ url()->previous() }}" class="back-link">
        <i class="fas fa-arrow-left"></i> Kembali
    </a>

    <h2 class="header-title">
        <i class="fas fa-user-cog"></i> Pengaturan Akun
    </h2>

    {{-- SECTION: PROFILE INFO --}}
    <div class="card">
        <div class="card-header-kopi">
            <h3><i class="fas fa-id-badge"></i> Profile Information</h3>
        </div>
        <div class="card-body-kopi">
            <p class="section-desc">Update informasi profil dan alamat email akun Anda secara berkala.</p>
            @include('profile.partials.update-profile-information-form')
        </div>
    </div>

    {{-- SECTION: PASSWORD --}}
    <div class="card">
        <div class="card-header-kopi">
            <h3><i class="fas fa-key"></i> Update Password</h3>
        </div>
        <div class="card-body-kopi">
            <p class="section-desc">Gunakan kata sandi yang kuat untuk menjaga keamanan akses menu Kopi Ketjeh Anda.</p>
            @include('profile.partials.update-password-form')
        </div>
    </div>

    {{-- SECTION: DELETE ACCOUNT --}}
    <div class="card card-danger">
        <div class="card-header-kopi">
            <h3><i class="fas fa-exclamation-triangle"></i> DELETE ACCOUNT</h3>
        </div>
        <div class="card-body-kopi">
            <div class="section-desc">
                Once your account is deleted, all of its resources and data will be permanently deleted.
                <br><br>
                <strong>Peringatan:</strong>Menghapus akun akan menghapus seluruh data pesanan Anda secara permanen.
            </div>
            @include('profile.partials.delete-user-form')
        </div>
    </div>

</div>

@endsection