<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Services\BiteshipService;

Route::post('/ping', fn () => response()->json(['status' => 'API OK']));

Route::post('/ongkir/rates', function (Request $request, BiteshipService $bs) {
    return response()->json(
        $bs->rates(
            $request->destination_area_id,
            $request->weight
        )
    );
});

Route::get('/search-area', function (Request $request, BiteshipService $bs) {
    return response()->json(
        $bs->cities($request->query('q', ''))
    );
});
