<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;

use App\Services\BiteshipService;

use App\Http\Controllers\{
    HomeController,
    ProfileController,
    CheckoutController,
    CartController,
    AkunController
};

use App\Http\Controllers\Admin\{
    AdminDashboardController,
    ProductController,
    OrderController,
    FinanceController,
    UserController
};

/*
|--------------------------------------------------------------------------
| HOME (PUBLIC)
|--------------------------------------------------------------------------
*/
Route::get('/', [HomeController::class, 'index'])->name('home');

/*
|--------------------------------------------------------------------------
| BITESHIP API (PUBLIC – DIPAKAI AJAX)
|--------------------------------------------------------------------------
| ❗ WAJIB DI LUAR AUTH
*/
Route::get('/search-area', function (Request $request, BiteshipService $bs) {
    return $bs->cities($request->query('q'));
});

Route::post('/ongkir/rates', function (Request $request, BiteshipService $bs) {
    return $bs->rates(
        $request->destination_area_id,
        $request->weight,
        $request->courier
    );
});

/*
|--------------------------------------------------------------------------
| AUTH USER
|--------------------------------------------------------------------------
*/
Route::middleware('auth')->group(function () {

    // ================= PROFILE =================
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // ================= AKUN =================
    Route::get('/akun', [AkunController::class, 'index'])->name('akun');

    // ================= CHECKOUT =================
    Route::post('/checkout/now/{product}', [CheckoutController::class, 'orderNow'])
        ->name('checkout.now');

    Route::get('/checkout', [CheckoutController::class, 'index'])
        ->name('checkout.index');

    Route::post('/checkout/update-qty/{product}', [CheckoutController::class, 'updateQty'])
        ->name('checkout.updateQty');

    Route::post('/checkout/pay', [CheckoutController::class, 'pay'])
        ->name('checkout.pay');

    // ================= PEMBAYARAN MANUAL =================
    Route::get('/payment/manual/{order}', [CheckoutController::class, 'manual'])
        ->name('payment.manual');

    Route::post('/payment/manual/{order}/upload', [CheckoutController::class, 'uploadProof'])
        ->name('payment.manual.upload');

    // ================= PESANAN SELESAI =================
    Route::patch('/pesanan/{order}/selesai',
        [AkunController::class, 'markAsCompleted']
    )->name('pesanan.selesai');

    // ================= CART =================
    Route::prefix('cart')->name('cart.')->group(function () {
    Route::get('/', [CartController::class, 'index'])->name('index');
    Route::post('/add/{product}', [CartController::class, 'add'])->name('add');
    Route::post('/update/{product}', [CartController::class, 'update'])->name('update');
    Route::post('/remove/{product}', [CartController::class, 'remove'])->name('remove');
    Route::get('/count', [CartController::class, 'count'])->name('count');

    // 🔥 TAMBAHAN INI SAJA
    Route::post('/checkout', [CartController::class, 'checkout'])
        ->name('checkout');
});

    // ================= LOGOUT =================
    Route::post('/logout', function () {
        Auth::logout();
        return redirect()->route('login');
    })->name('logout');
});

/*
|--------------------------------------------------------------------------
| ADMIN
|--------------------------------------------------------------------------
*/
Route::middleware(['auth', 'admin'])
    ->prefix('admin')
    ->name('admin.')
    ->group(function () {

        Route::get('/', [AdminDashboardController::class, 'index'])
            ->name('dashboard');

        Route::resource('products', ProductController::class);

        Route::get('orders', [OrderController::class, 'index'])
            ->name('orders.index');

        Route::get('orders/{order}', [OrderController::class, 'show'])
            ->name('orders.show');

        Route::patch('orders/{order}/status', [OrderController::class, 'updateStatus'])
            ->name('orders.updateStatus');

        Route::get('finance', [FinanceController::class, 'index'])
            ->name('finance.index');

        Route::get('users', [UserController::class, 'index'])
            ->name('users.index');

        Route::patch('users/{user}/role', [UserController::class, 'updateRole'])
            ->name('users.updateRole');

        Route::delete('users/{user}', [UserController::class, 'destroy'])
            ->name('users.destroy');
    });

/*
|--------------------------------------------------------------------------
| AUTH ROUTES (LOGIN / REGISTER / DLL)
|--------------------------------------------------------------------------
*/
require __DIR__.'/auth.php';
