

<?php $__env->startSection('title', 'Detail Pesanan #' . $order->id); ?>

<?php $__env->startSection('content'); ?>
<div class="kopi-order-card">

    
    <div class="kopi-card-header">
        <div class="header-info">
            <h3>
                <i class="fas fa-receipt"></i>
                Detail Pesanan #<?php echo e($order->id); ?>

            </h3>
            <p>Informasi transaksi dan pengiriman Kopi Ketjeh</p>
        </div>

        <a href="<?php echo e(route('admin.orders.index')); ?>" class="btn-kopi-back">
            <i class="fas fa-arrow-left"></i> Kembali
        </a>
    </div>

    
    <?php if(session('success')): ?>
        <div class="kopi-alert-success">
            <i class="fas fa-check-circle"></i> <?php echo e(session('success')); ?>

        </div>
    <?php endif; ?>

    <div class="kopi-card-body">

        
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-user-circle"></i> Data Pelanggan
            </h4>

            <div class="kopi-detail-list">
                <div class="detail-item">
                    <strong>Nama Akun:</strong>
                    <span><?php echo e($order->user->name ?? '-'); ?></span>
                </div>

                <div class="detail-item">
                    <strong>Nama Penerima:</strong>
                    <span><?php echo e($order->receiver_name ?? '-'); ?></span>
                </div>

                <div class="detail-item">
                    <strong>Alamat Pengiriman:</strong>
                    <span><?php echo e($order->address); ?></span>
                </div>

                <div class="detail-item">
                    <strong>No. WhatsApp:</strong>
                    <span><?php echo e($order->phone); ?></span>
                </div>
            </div>
        </div>

        
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-credit-card"></i> Data Pembayaran
            </h4>

            <div class="kopi-detail-list">
                <div class="detail-item">
                    <strong>Metode:</strong>
                    <span><?php echo e(strtoupper($order->payment_method ?? '-')); ?></span>
                </div>

                <div class="detail-item">
                    <strong>Bank / E-Wallet:</strong>
                    <span><?php echo e(strtoupper($order->payment_name ?? '-')); ?></span>
                </div>

                <div class="detail-item">
                    <strong>Nomor Tujuan:</strong>
                    <span><?php echo e($order->payment_number ?? '-'); ?></span>
                </div>

                <div class="detail-item">
                    <strong>Atas Nama:</strong>
                    <span>Kopi Ketjeh</span>
                </div>

                <div class="detail-item">
                    <strong>Status Pembayaran:</strong>
                    <?php if($order->status === 'pending'): ?>
                        <span style="color:#b45309;font-weight:700;"><i class="fas fa-clock"></i>
                            Menunggu Pembayaran
                        </span>
                    <?php elseif($order->status === 'paid'): ?>
                        <span style="color:#15803d;font-weight:700;">
                            <i class="fas fa-check-circle"></i>Sudah Dibayar
                        </span>
                    <?php else: ?>
                        <span><?php echo e(ucfirst($order->status)); ?></span>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-image"></i> Bukti Pembayaran
            </h4>

            <?php if($order->payment_proof): ?>
                <a href="<?php echo e(asset('storage/'.$order->payment_proof)); ?>" target="_blank">
                    <img
                        src="<?php echo e(asset('storage/'.$order->payment_proof)); ?>"
                        alt="Bukti Pembayaran"
                        style="max-width:280px;border-radius:10px;border:1px solid #ddd;"
                    >
                </a>
                <p style="font-size:12px;color:#777;margin-top:6px;">
                    Klik gambar untuk memperbesar
                </p>
            <?php else: ?>
                <p style="color:#999;font-style:italic;">
                    Bukti pembayaran belum diunggah oleh pelanggan.
                </p>
            <?php endif; ?>
        </div>

        
        <div class="kopi-info-group">
            <h4 class="kopi-label-group">
                <i class="fas fa-coffee"></i> Item yang Dipesan
            </h4>

            <div class="header-minimal header-3col">
                <span>Nama Produk</span>
                <span class="center">Jumlah</span>
                <span class="right">Total</span>
            </div>
            <div class="product-list-clean">
                <?php $__currentLoopData = $order->items; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="row-3col">
                        <span><?php echo e($item->product->name); ?></span>
                        <span class="center"><?php echo e($item->qty); ?></span>
                        <span class="right">
                            Rp <?php echo e(number_format($item->price * $item->qty, 0, ',', '.')); ?>

                        </span>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <div class="row-summary">
                <span>Biaya Pengiriman</span>
                <span class="right">
                    Rp <?php echo e(number_format($order->shipping_cost ?? 0, 0, ',', '.')); ?>

                </span>
            </div>
            <div class="row-summary total">
                <span>Total Pembayaran</span>
                <span class="right">
                    Rp <?php echo e(number_format($order->total_price, 0, ',', '.')); ?>

                </span>
            </div>
        </div>
        
<div class="kopi-info-group">
    <h4 class="kopi-label-group">
        <i class="fas fa-truck"></i> Detail Pengiriman
    </h4>

    <div class="kopi-detail-list">
        <div class="detail-item">
            <strong>Penerima:</strong>
            <span><?php echo e($order->receiver_name); ?></span>
        </div>

        <div class="detail-item">
            <strong>No. HP:</strong>
            <span><?php echo e($order->phone); ?></span>
        </div>

        <div class="detail-item">
            <strong>Alamat:</strong>
            <span><?php echo e($order->address); ?></span>
        </div>

        <div class="detail-item">
            <strong>Kurir:</strong>
            <span><?php echo e(strtoupper($order->courier ?? '-')); ?></span>
        </div>
        <div class="detail-item">
            <strong>Ongkir:</strong>
            <span>
                Rp <?php echo e(number_format($order->shipping_cost, 0, ',', '.')); ?>

            </span>
        </div>
    </div>
</div>


        
        <div class="kopi-info-group no-border">
            <h4 class="kopi-label-group">
                <i class="fas fa-truck"></i> Update Status & Logistik
            </h4>

            <?php if($order->status === 'pending' && !$order->payment_proof): ?>
                <p style="font-size:12px;color:#b45309;margin-bottom:10px;">
                    ⚠️ Pastikan bukti pembayaran sudah diunggah sebelum mengubah status ke
                    <strong>PAID</strong>.
                </p>
            <?php endif; ?>

            <form method="POST" action="<?php echo e(route('admin.orders.updateStatus', $order)); ?>">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PATCH'); ?>

                <div class="kopi-field">
                    <label>Status Pesanan</label>
                    <select name="status" id="statusSelect" class="kopi-control">
                        <?php $__currentLoopData = ['pending','paid','process','shipped','completed','cancelled']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $status): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($status); ?>"
                                <?php echo e($order->status === $status ? 'selected' : ''); ?>

                                <?php if($status === 'paid' && !$order->payment_proof): ?> disabled <?php endif; ?>
                            >
                                <?php echo e(ucfirst($status)); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div id="shippingFields"
                     style="<?php echo e($order->status === 'shipped' ? '' : 'display:none;'); ?>">

                    <div class="kopi-field">
                        <label>Kurir</label>
                        <input type="text" name="courier"
                               class="kopi-control"
                               value="<?php echo e($order->courier); ?>">
                    </div>

                    <div class="kopi-field">
                        <label>No. Resi</label>
                        <input type="text" name="tracking_number"
                               class="kopi-control"
                               value="<?php echo e($order->tracking_number); ?>">
                    </div>
                </div>

                <button type="submit" class="btn-kopi-blue">
                    Simpan Perubahan
                </button>
            </form>
        </div>

    </div>
</div>

<script>
document.getElementById('statusSelect').addEventListener('change', function () {
    document.getElementById('shippingFields').style.display =
        this.value === 'shipped' ? 'block' : 'none';
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\kuliah\semester 5\PAKTIKUM\Kopi_Ketjeh(terbaru)\resources\views/admin/orders/show.blade.php ENDPATH**/ ?>