<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Mdata;

class Utama extends Controller
{
    public function statusAPI()
    {
        $drespon = [
            "kode" => "01",
            "status" => "API Berjalan dengan Baik"
        ];
        return response()->json($drespon, 200);
    }

    public function backupData(Request $xyz)
    {
        $nama  = $xyz->input("nama_backup");
        $dtx   = base64_decode($xyz->input("dtx"));
        $idx   = floor(microtime(true) * 1000);
        $arr_data = explode("#", $dtx);
        $mx    = new Mdata();
        $proses = $mx->TambahBackup($idx, $nama);

        if ($proses == "1") {
            $berhasil = 0;
            $gagal = 0;

            foreach ($arr_data as $k) {
                $arr_data2 = explode("|", $k);
                $id        = $arr_data2[0];
                $nominalx  = $arr_data2[1];
                $waktux    = $arr_data2[2];
                $jenisx    = $arr_data2[3];
                $deskripsix = $arr_data2[4];

                $simpan = $mx->TambahTransaksi(
                    $id . "_" . $idx, $id, $waktux, $nominalx, $jenisx, $deskripsix
                );

                if ($simpan == "1") {
                    $berhasil++;
                } else {
                    $gagal++;
                }
            }

            return [
                "kode" => "1",
                "pesan" => "Proses Backup Berhasil dengan Rincian",
                "berhasil" => $berhasil,
                "gagal" => $gagal
            ];
        } else {
            return [
                "kode" => "0",
                "pesan" => "Proses Backup Gagal, Periksa Kembali Isian Anda"
            ];
        }
    }
}
