<?php
include 'koneksi.php'; // koneksi ke database

// Ambil data rating dari database
$sql = "SELECT * FROM ratings";
$result = $conn->query($sql);

$data = [];
$items = ['Interstellar', 'Inception', 'Titanic', 'Avatar', 'Matrix'];
?>
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Prediksi Rating Film - Item-Based CF</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            background: linear-gradient(-45deg, #1a1a2e, #16213e, #0f3460, #1b1b2f);
            background-size: 400% 400%;
            animation: gradientBG 20s ease infinite;
            color: #fff;
            margin: 0;
            padding: 20px;
        }

        @keyframes gradientBG {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }

        .judul-utama {
            text-align: center;
            margin-bottom: 30px;
            font-size: 30px;
            color: #ffcc00;
            text-shadow: 0 0 10px rgba(255,204,0,0.8);
        }

        .identitas {
            display: flex;
            align-items: center;
            background: rgba(255,255,255,0.08);
            padding: 20px;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.2);
            max-width: 800px;
            margin: 0 auto 30px;
            backdrop-filter: blur(10px);
        }

        .identitas img {
            width: 120px;
            border-radius: 10px;
            margin-right: 20px;
        }

        .identitas div p {
            margin: 5px 0;
            color: #fff;
            font-size: 22px;
            font-weight: bold;
        }

        h2 {
            text-align: center;
            color: #ffcc00;
            margin-top: 30px;
        }

        .judul-tabel {
            text-align: center;
            margin-top: 40px;
            font-size: 26px;
            color: #00ffc8;
            text-shadow: 0 0 8px rgba(0,255,200,0.8);
        }

        table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 20px;
            background: rgba(255,255,255,0.05);
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 1px 6px rgba(0,0,0,0.2);
            backdrop-filter: blur(6px);
        }

        th, td {
            border: 1px solid #555;
            padding: 10px;
            text-align: center;
            color: #fff;
        }

        th {
            background-color: #ffcc00;
            color: #000;
        }

        tr:nth-child(even) {
            background-color: rgba(255, 255, 255, 0.05);
        }

        .hasil {
            background: linear-gradient(145deg, #1f4037, #99f2c8);
            color: #fff;
            border-radius: 15px;
            box-shadow: 0 5px 15px rgba(0,0,0,0.25);
            text-align: center;
            max-width: 500px;
            margin: 40px auto;
            padding: 25px;
            font-size: 20px;
            animation: fadeIn 1.2s ease-in-out;
        }

        .btn-toggle {
            display: inline-block;
            padding: 12px 20px;
            margin: 10px;
            font-size: 16px;
            background-color: #007bff;
            color: white;
            border: none;
            border-radius: 8px;
            cursor: pointer;
            transition: background-color 0.3s;
        }

        .btn-toggle:hover {
            background-color: #0056b3;
        }

        .toggle-section {
            display: none;
            max-width: 900px;
            margin: 30px auto;
            padding: 30px 35px;
            border-radius: 16px;
            box-shadow: 0 4px 12px rgba(0,0,0,0.3);
            font-size: 18px;
            background-color: rgba(255,255,255,0.1);
            color: #fff;
            backdrop-filter: blur(8px);
        }

        .langkah { border-left: 8px solid #ffc107; }
        .perhitungan { border-left: 8px solid #2196f3; }

        .toggle-section h2 {
            margin-top: 0;
            font-size: 26px;
            color: #ffcc00;
        }

        @keyframes spin {
          0% { transform: rotate(0deg);}
          100% { transform: rotate(360deg);}
        }

        @keyframes fadeIn {
          0% { opacity: 0; transform: scale(0.9);}
          100% { opacity: 1; transform: scale(1);}
        }
    </style>
    <script>
        function toggleVisibility(id) {
            const section = document.getElementById(id);
            section.style.display = (section.style.display === "block") ? "none" : "block";
        }
    </script>
</head>
<body>

<!-- Judul Utama -->
<div class="judul-utama">
    🎥 Sistem Rekomendasi Film Menggunakan Metode <br> <em>Item-Based Collaborative Filtering</em>
</div>

<!-- Identitas Mahasiswa -->
<div class="identitas">
    <img src="fotoku.png" alt="Foto Mahasiswa">
    <div>
        <p><strong>NIM:</strong> 2302050841</p>
        <p><strong>Nama:</strong> Nur Aida Aslimah Wardatul Jannah</p>
        <p><strong>Prodi:</strong> Sistem Informasi</p>
        <p><strong>Kelas:</strong> SI-A</p>
    </div>
</div>

<!-- Judul Data -->
<h2 class="judul-tabel">🎬 Data Rating Pengguna</h2>

<!-- Tabel Data -->
<table>
    <tr>
        <th>User</th>
        <?php foreach ($items as $item) echo "<th>$item</th>"; ?>
    </tr>
    <?php
    if ($result->num_rows > 0) {
        while ($row = $result->fetch_assoc()) {
            $user = $row['User'];
            echo "<tr><td>$user</td>";
            foreach ($items as $item) {
                $val = (int)$row[$item];
                $data[$user][$item] = $val;
                echo "<td>$val</td>";
            }
            echo "</tr>";
        }
    } else {
        echo "<tr><td colspan='6'>Tidak ada data</td></tr>";
    }
    ?>
</table>

<?php
// Matrix dan Similarity
$item_user_matrix = [];
foreach ($items as $item) {
    foreach ($data as $user => $ratings) {
        $item_user_matrix[$item][$user] = $ratings[$item];
    }
}

function cosineSimilarity($a, $b) {
    $dot = 0; $normA = 0; $normB = 0;
    foreach ($a as $i => $valA) {
        $valB = $b[$i];
        $dot += $valA * $valB;
        $normA += pow($valA, 2);
        $normB += pow($valB, 2);
    }
    return ($normA && $normB) ? $dot / (sqrt($normA) * sqrt($normB)) : 0;
}

$item_similarity = [];
foreach ($items as $itemA) {
    foreach ($items as $itemB) {
        $item_similarity[$itemA][$itemB] = cosineSimilarity($item_user_matrix[$itemA], $item_user_matrix[$itemB]);
    }
}

function predictRatingItemBased($user_id, $target_item, $data, $item_similarity) {
    $user_ratings = $data[$user_id];
    $numerator = 0;
    $denominator = 0;
    foreach ($user_ratings as $item => $rating) {
        if ($item != $target_item && $rating != 0) {
            $sim = $item_similarity[$target_item][$item];
            $numerator += $sim * $rating;
            $denominator += abs($sim);
        }
    }
    return ($denominator != 0) ? $numerator / $denominator : 0;
}

// Prediksi U6 terhadap Titanic
$predicted = predictRatingItemBased('U6', 'Titanic', $data, $item_similarity);
?>

<!-- Hasil Prediksi -->
<div class="hasil">
    <img src="https://cdn-icons-png.flaticon.com/512/1828/1828884.png" alt="Rating Star" 
         style="width: 50px; animation: spin 3s linear infinite;">
    <p><strong>Prediksi Rating <span style="color:#ffe600;">U6</span></strong> terhadap <strong style="color:#ffea00;">Titanic</strong>:</p>
    <div style="font-size: 36px; margin-top: 10px;">⭐ <strong><?= round($predicted, 2) ?> / 5</strong></div>
    <p style="margin-top: 10px;">Jika dibulatkan menjadi <strong><?= round($predicted) ?> / 5</strong></p>
</div>


<!-- Tombol Toggle -->
<div style="text-align: center;">
    <button class="btn-toggle" onclick="toggleVisibility('langkah')">📘 Tampilkan Langkah-Langkah</button>
    <button class="btn-toggle" onclick="toggleVisibility('perhitungan')">📐 Tampilkan Perhitungan Manual</button>
</div>

<!-- Penjelasan Langkah -->
<div id="langkah" class="toggle-section langkah">
    <h2>🧩 Langkah-Langkah Prediksi</h2>
    <ol style="line-height:1.8; padding-left:25px;">
        <li>Ambil data rating dari database dan bentuk User-Item Matrix.</li>
        <li>Lakukan transpose menjadi Item-User Matrix.</li>
        <li>Hitung cosine similarity antara item target (<strong>Titanic</strong>) dan item lainnya.</li>
        <li>Ambil rating user <strong>U6</strong> terhadap item selain Titanic.</li>
        <li>Gunakan rumus:
            <div style="background:#fff3cd; color:#000; padding:15px; border-radius:8px; margin:12px 0;">
                <code><strong>Prediksi = (Σ (similarity × rating)) / (Σ |similarity|)</strong></code>
            </div>
        </li>
    </ol>
</div>

<!-- Perhitungan Manual -->
<div id="perhitungan" class="toggle-section perhitungan">
    <h2>📐 Perhitungan Manual</h2>
    <p><strong>Rating U6:</strong><br>
        Interstellar = <?= $data['U6']['Interstellar'] ?>, 
        Inception = <?= $data['U6']['Inception'] ?>, 
        Avatar = <?= $data['U6']['Avatar'] ?>, 
        Matrix = <?= $data['U6']['Matrix'] ?>
    </p>

    <p><strong>Similarity Titanic terhadap:</strong><br>
        Interstellar = <?= round($item_similarity['Titanic']['Interstellar'], 3) ?><br>
        Inception = <?= round($item_similarity['Titanic']['Inception'], 3) ?><br>
        Avatar = <?= round($item_similarity['Titanic']['Avatar'], 3) ?><br>
        Matrix = <?= round($item_similarity['Titanic']['Matrix'], 3) ?>
    </p>

    <p><strong>Numerator:</strong><br>
        <?= 
            round($item_similarity['Titanic']['Interstellar'] * $data['U6']['Interstellar'], 3) . " + " .
            round($item_similarity['Titanic']['Inception'] * $data['U6']['Inception'], 3) . " + " .
            round($item_similarity['Titanic']['Avatar'] * $data['U6']['Avatar'], 3) . " + " .
            round($item_similarity['Titanic']['Matrix'] * $data['U6']['Matrix'], 3)
        ?>
    </p>

    <p><strong>Denominator:</strong><br>
        <?= 
            round(abs($item_similarity['Titanic']['Interstellar']), 3) . " + " .
            round(abs($item_similarity['Titanic']['Inception']), 3) . " + " .
            round(abs($item_similarity['Titanic']['Avatar']), 3) . " + " .
            round(abs($item_similarity['Titanic']['Matrix']), 3)
        ?>
    </p>

    <p><strong>Hasil Akhir:</strong><br>
        Prediksi rating U6 terhadap Titanic = <strong><?= round($predicted, 2) ?></strong><br>
        Jika dibulatkan menjadi <strong><?= round($predicted) ?> / 5</strong>
    </p>
</div>

</body>
</html>
